/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.services.jwt;

import io.github.isagroup.PricingContext;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PricingJwtUtils {
    @Autowired
    private PricingContext pricingContext;
    private static final Logger logger = LoggerFactory.getLogger(PricingJwtUtils.class);

    public PricingJwtUtils(PricingContext pricingContext) {
        this.pricingContext = pricingContext;
    }

    public String getSubjectFromJwtToken(String token) {
        return ((Claims)Jwts.parser().setSigningKey(this.pricingContext.getJwtSecret()).parseClaimsJws(token).getBody()).getSubject();
    }

    public String generateTokenFromUsername(String username) {
        HashMap claims = new HashMap();
        return Jwts.builder().setClaims(claims).setSubject(username).setIssuedAt(new Date()).setExpiration(new Date(new Date().getTime() + (long)this.pricingContext.getJwtExpiration())).signWith(SignatureAlgorithm.HS512, this.pricingContext.getJwtSecret()).compact();
    }

    public Map<String, Map<String, Object>> getFeaturesFromJwtToken(String token) {
        return (Map)((Claims)Jwts.parser().setSigningKey(this.pricingContext.getJwtSecret()).parseClaimsJws(token).getBody()).get((Object)"features");
    }

    public Map<String, Object> getPlanContextFromJwtToken(String token) {
        return (Map)((Claims)Jwts.parser().setSigningKey(this.pricingContext.getJwtSecret()).parseClaimsJws(token).getBody()).get((Object)"planContext");
    }

    public Map<String, Object> getUserContextFromJwtToken(String token) {
        return (Map)((Claims)Jwts.parser().setSigningKey(this.pricingContext.getJwtSecret()).parseClaimsJws(token).getBody()).get((Object)"userContext");
    }

    public String getUserNameFromJwtToken(String token) {
        return ((Claims)Jwts.parser().setSigningKey(this.pricingContext.getJwtSecret()).parseClaimsJws(token).getBody()).getSubject();
    }

    public boolean validateJwtToken(String authToken) {
        try {
            Jwts.parser().setSigningKey(this.pricingContext.getJwtSecret()).parseClaimsJws(authToken);
            return true;
        }
        catch (SignatureException e) {
            logger.error("Invalid JWT signature: {}", (Object)e.getMessage());
        }
        catch (MalformedJwtException e) {
            logger.error("Invalid JWT: {}", (Object)e.getMessage());
        }
        catch (ExpiredJwtException e) {
            logger.error("JWT is expired: {}", (Object)e.getMessage());
        }
        catch (UnsupportedJwtException e) {
            logger.error("JWT is unsupported: {}", (Object)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            logger.error("JWT claims string is empty: {}", (Object)e.getMessage());
        }
        return false;
    }
}

