/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.services.parsing;

import io.github.isagroup.exceptions.PricingParsingException;
import io.github.isagroup.models.AddOn;
import io.github.isagroup.models.Feature;
import io.github.isagroup.models.Plan;
import io.github.isagroup.models.PricingManager;
import io.github.isagroup.models.UsageLimit;
import io.github.isagroup.services.parsing.AddOnParser;
import io.github.isagroup.services.parsing.FeatureParser;
import io.github.isagroup.services.parsing.PlanParser;
import io.github.isagroup.services.parsing.UsageLimitParser;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class PricingManagerParser {
    private PricingManagerParser() {
    }

    public static PricingManager parseMapToPricingManager(Map<String, Object> yamlConfigMap) {
        PricingManager pricingManager = new PricingManager();
        PricingManagerParser.setBasicAttributes(yamlConfigMap, pricingManager);
        PricingManagerParser.setFeatures(yamlConfigMap, pricingManager);
        PricingManagerParser.setUsageLimits(yamlConfigMap, pricingManager);
        PricingManagerParser.setPlans(yamlConfigMap, pricingManager);
        PricingManagerParser.setAddOns(yamlConfigMap, pricingManager);
        if (pricingManager.getPlans() == null && pricingManager.getAddOns() == null) {
            throw new PricingParsingException("The pricing manager does not have any plans or add ons");
        }
        return pricingManager;
    }

    private static void setBasicAttributes(Map<String, Object> yamlConfigMap, PricingManager pricingManager) throws PricingParsingException {
        if (yamlConfigMap.get("saasName") == null) {
            throw new PricingParsingException("SaasName was not defined");
        }
        if (yamlConfigMap.get("day") == null) {
            throw new PricingParsingException("Day of plan was not defined");
        }
        if (yamlConfigMap.get("month") == null) {
            throw new PricingParsingException("Monnth of plan was not defined");
        }
        if (yamlConfigMap.get("year") == null) {
            throw new PricingParsingException("Year of plan was not defined");
        }
        if (yamlConfigMap.get("currency") == null) {
            throw new PricingParsingException("Currency was not defined");
        }
        if (yamlConfigMap.get("hasAnnualPayment") != null) {
            pricingManager.setHasAnnualPayment((Boolean)yamlConfigMap.get("hasAnnualPayment"));
        }
        pricingManager.setSaasName((String)yamlConfigMap.get("saasName"));
        pricingManager.setDay((Integer)yamlConfigMap.get("day"));
        pricingManager.setMonth((Integer)yamlConfigMap.get("month"));
        pricingManager.setYear((Integer)yamlConfigMap.get("year"));
        pricingManager.setCurrency((String)yamlConfigMap.get("currency"));
    }

    private static void setFeatures(Map<String, Object> map, PricingManager pricingManager) {
        LinkedHashMap<String, Feature> pricingFeatures = new LinkedHashMap<String, Feature>();
        Map featuresMap = new HashMap();
        try {
            featuresMap = (Map)map.get("features");
        }
        catch (ClassCastException e) {
            throw new PricingParsingException("The features are not defined correctly. It should be a map of features and their options");
        }
        if (featuresMap == null) {
            throw new IllegalArgumentException("The pricing manager does not have any features");
        }
        for (String featureName : featuresMap.keySet()) {
            try {
                Map featureMap = (Map)featuresMap.get(featureName);
                Feature feature = FeatureParser.parseMapToFeature(featureName, featureMap);
                pricingFeatures.put(featureName, feature);
            }
            catch (ClassCastException e) {
                throw new PricingParsingException("The feature " + featureName + " is not defined correctly. All its options must be specified, and it cannot be defined as a key-value pair");
            }
        }
        pricingManager.setFeatures(pricingFeatures);
    }

    private static void setUsageLimits(Map<String, Object> map, PricingManager pricingManager) {
        Map usageLimitsMap = (Map)map.get("usageLimits");
        LinkedHashMap<String, UsageLimit> usageLimits = new LinkedHashMap<String, UsageLimit>();
        if (usageLimitsMap == null) {
            return;
        }
        for (String limitName : usageLimitsMap.keySet()) {
            Map limitMap = (Map)usageLimitsMap.get(limitName);
            UsageLimit limit = UsageLimitParser.parseMapToFeature(limitName, limitMap, pricingManager);
            usageLimits.put(limitName, limit);
        }
        pricingManager.setUsageLimits(usageLimits);
    }

    private static void setPlans(Map<String, Object> map, PricingManager pricingManager) {
        Map plansMap = new HashMap();
        try {
            plansMap = (Map)map.get("plans");
        }
        catch (ClassCastException e) {
            throw new PricingParsingException("The plans are not defined correctly. It should be a map of plans and their options");
        }
        LinkedHashMap<String, Plan> plans = new LinkedHashMap<String, Plan>();
        if (plansMap == null) {
            return;
        }
        for (String planName : plansMap.keySet()) {
            Map planMap = (Map)plansMap.get(planName);
            Plan plan = PlanParser.parseMapToPlan(planName, planMap, pricingManager);
            plans.put(planName, plan);
        }
        pricingManager.setPlans(plans);
    }

    private static void setAddOns(Map<String, Object> map, PricingManager pricingManager) {
        Map addOnsMap = (Map)map.get("addOns");
        LinkedHashMap<String, AddOn> addOns = new LinkedHashMap<String, AddOn>();
        if (addOnsMap == null) {
            return;
        }
        for (String addOnName : addOnsMap.keySet()) {
            Map addOnMap = (Map)addOnsMap.get(addOnName);
            AddOn addOn = AddOnParser.parseMapToAddOn(addOnName, addOnMap, pricingManager);
            addOns.put(addOnName, addOn);
        }
        pricingManager.setAddOns(addOns);
    }
}

