/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.services.parsing;

import io.github.isagroup.exceptions.PricingParsingException;
import io.github.isagroup.exceptions.VersionException;
import io.github.isagroup.models.AddOn;
import io.github.isagroup.models.Feature;
import io.github.isagroup.models.Plan;
import io.github.isagroup.models.PricingManager;
import io.github.isagroup.models.UsageLimit;
import io.github.isagroup.services.parsing.AddOnParser;
import io.github.isagroup.services.parsing.FeatureParser;
import io.github.isagroup.services.parsing.PlanParser;
import io.github.isagroup.services.parsing.UsageLimitParser;
import io.github.isagroup.services.updaters.Version;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class PricingManagerParser {
    private PricingManagerParser() {
    }

    public static PricingManager parseMapToPricingManager(Map<String, Object> yamlConfigMap) {
        PricingManager pricingManager = new PricingManager();
        PricingManagerParser.setBasicAttributes(yamlConfigMap, pricingManager);
        PricingManagerParser.setFeatures(yamlConfigMap, pricingManager);
        PricingManagerParser.setUsageLimits(yamlConfigMap, pricingManager);
        PricingManagerParser.setPlans(yamlConfigMap, pricingManager);
        PricingManagerParser.setAddOns(yamlConfigMap, pricingManager);
        if (pricingManager.getPlans() == null && pricingManager.getAddOns() == null) {
            throw new PricingParsingException("The pricing manager does not have any plans or add ons");
        }
        return pricingManager;
    }

    private static void setBasicAttributes(Map<String, Object> yamlConfigMap, PricingManager pricingManager) {
        Version version;
        block22: {
            version = null;
            try {
                if (yamlConfigMap.get("version") == null) {
                    version = Version.V1_0;
                    break block22;
                }
                if (yamlConfigMap.get("version") instanceof Double || yamlConfigMap.get("version") instanceof String) {
                    version = Version.version(yamlConfigMap.get("version"));
                    break block22;
                }
                throw new PricingParsingException(String.format("'version' detected type is %s but 'version' type must be Double or String", yamlConfigMap.get("version").getClass().getSimpleName()));
            }
            catch (VersionException e) {
                throw new PricingParsingException(e.getMessage());
            }
        }
        pricingManager.setVersion(version);
        if (yamlConfigMap.get("saasName") == null) {
            throw new PricingParsingException("SaasName was not defined");
        }
        if (!(yamlConfigMap.get("saasName") instanceof String)) {
            throw new PricingParsingException("'saasName' has to be a string");
        }
        pricingManager.setSaasName((String)yamlConfigMap.get("saasName"));
        if (yamlConfigMap.get("url") != null && !(yamlConfigMap.get("url") instanceof String)) {
            throw new PricingParsingException("If 'url' field is used, it has to be a string");
        }
        if (yamlConfigMap.get("createdAt") == null) {
            throw new PricingParsingException("'createdAt' is mandatory. Check your config file.");
        }
        if (yamlConfigMap.get("createdAt") instanceof Date) {
            Date createdAt = (Date)yamlConfigMap.get("createdAt");
            pricingManager.setCreatedAt(createdAt.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        } else if (yamlConfigMap.get("createdAt") instanceof String) {
            try {
                pricingManager.setCreatedAt(LocalDate.parse((String)yamlConfigMap.get("createdAt")));
            }
            catch (DateTimeParseException err) {
                throw new PricingParsingException(String.format("\"createdAt\" \"%s\" is invalid, use the following yyyy-MM-dd", yamlConfigMap.get("createdAt")));
            }
        } else {
            throw new PricingParsingException(String.format("\"createdAt\" detected type is %s and must be a String or Date formatted like yyyy-MM-dd", yamlConfigMap.get("createdAt").getClass().getSimpleName()));
        }
        if (yamlConfigMap.get("currency") == null) {
            throw new PricingParsingException("Currency was not defined");
        }
        if (!(yamlConfigMap.get("currency") instanceof String)) {
            throw new PricingParsingException("'currency' has to be a string");
        }
        pricingManager.setCurrency((String)yamlConfigMap.get("currency"));
        if (yamlConfigMap.get("tags") != null && !(yamlConfigMap.get("tags") instanceof List)) {
            throw new PricingParsingException(String.format("\"tags\" type is %s and must be a List", yamlConfigMap.get("tags").getClass().getSimpleName()));
        }
        if (yamlConfigMap.get("tags") != null) {
            pricingManager.setTags((List)yamlConfigMap.get("tags"));
        }
        PricingManagerParser.checkVariables(yamlConfigMap);
        pricingManager.setVariables((Map)yamlConfigMap.get("variables"));
        if (yamlConfigMap.get("billing") != null) {
            if (!(yamlConfigMap.get("billing") instanceof Map)) {
                throw new PricingParsingException(String.format("\"billing\" type is %s and must be a Map", yamlConfigMap.get("billing").getClass().getSimpleName()));
            }
            Map billingMap = (Map)yamlConfigMap.get("billing");
            LinkedHashMap<String, Double> parsedBilling = new LinkedHashMap<String, Double>();
            for (Map.Entry entry : billingMap.entrySet()) {
                if (!(entry.getValue() instanceof Double)) {
                    throw new PricingParsingException(String.format("The value for billing key '%s' must be a Double but found %s", entry.getKey(), entry.getValue().getClass().getSimpleName()));
                }
                parsedBilling.put((String)entry.getKey(), (Double)entry.getValue());
            }
            pricingManager.setBilling(parsedBilling);
        }
    }

    private static void checkVariables(Map<String, Object> yamlConfigMap) {
        Pattern pattern = Pattern.compile("^[a-zA-Z][a-zA-Z0-9]*$");
        if (yamlConfigMap.get("variables") != null && !(yamlConfigMap.get("variables") instanceof Map)) {
            throw new PricingParsingException("variables must be a map but found " + yamlConfigMap.get("variables").getClass().getSimpleName() + " instead");
        }
        if (yamlConfigMap.get("variables") != null && yamlConfigMap.get("variables") instanceof Map) {
            for (Object key : ((Map)yamlConfigMap.get("variables")).keySet()) {
                if (key == null) {
                    throw new PricingParsingException("null is not a valid key for a variable");
                }
                if (pattern.matcher(key.toString()).matches()) continue;
                throw new PricingParsingException(String.valueOf(key) + " is not a valid name for a variable. ");
            }
        }
    }

    private static void setFeatures(Map<String, Object> map, PricingManager pricingManager) {
        if (map.get("features") == null) {
            throw new PricingParsingException("'features' is mandatory. It should be a map of features with their correspoding attributes.");
        }
        if (!(map.get("features") instanceof Map)) {
            throw new PricingParsingException("'features' must be a Map but found " + map.get("features").getClass().getSimpleName() + " instead");
        }
        LinkedHashMap<String, Feature> pricingFeatures = new LinkedHashMap<String, Feature>();
        Map featuresMap = (Map)map.get("features");
        featuresMap.entrySet().stream().filter(entry -> !(entry.getValue() instanceof Map)).findFirst().ifPresent(entry -> {
            throw new PricingParsingException(String.format("Feature '%s' must be a Map but found %s instead", entry.getKey(), entry.getValue().getClass().getSimpleName()));
        });
        for (String featureName : featuresMap.keySet()) {
            try {
                Map featureMap = (Map)featuresMap.get(featureName);
                Feature feature = FeatureParser.parseMapToFeature(featureName, featureMap);
                pricingFeatures.put(featureName, feature);
            }
            catch (ClassCastException e) {
                throw new PricingParsingException("An error has occurred while parsing the feature " + featureName + ". Error: " + e.getMessage());
            }
        }
        pricingManager.setFeatures(pricingFeatures);
    }

    private static void setUsageLimits(Map<String, Object> map, PricingManager pricingManager) {
        Map usageLimitsMap = (Map)map.get("usageLimits");
        LinkedHashMap<String, UsageLimit> usageLimits = new LinkedHashMap<String, UsageLimit>();
        if (usageLimitsMap == null) {
            return;
        }
        for (String limitName : usageLimitsMap.keySet()) {
            try {
                Map limitMap = (Map)usageLimitsMap.get(limitName);
                UsageLimit limit = UsageLimitParser.parseMapToUsageLimit(limitName, limitMap, pricingManager);
                usageLimits.put(limitName, limit);
            }
            catch (ClassCastException e) {
                throw new PricingParsingException("An error has occurred while parsing the usage limit " + limitName + ". Error: " + e.getMessage());
            }
        }
        pricingManager.setUsageLimits(usageLimits);
    }

    private static void setPlans(Map<String, Object> map, PricingManager pricingManager) {
        Map plansMap = new HashMap();
        try {
            plansMap = (Map)map.get("plans");
        }
        catch (ClassCastException e) {
            throw new PricingParsingException("The plans are not defined correctly. It should be a map of plans and their options");
        }
        LinkedHashMap<String, Plan> plans = new LinkedHashMap<String, Plan>();
        if (plansMap == null) {
            return;
        }
        for (String planName : plansMap.keySet()) {
            try {
                Map planMap = (Map)plansMap.get(planName);
                Plan plan = PlanParser.parseMapToPlan(planName, planMap, pricingManager);
                plans.put(planName, plan);
            }
            catch (ClassCastException e) {
                throw new PricingParsingException("An error has occurred while parsing the plan " + planName + ". Error: " + e.getMessage());
            }
        }
        pricingManager.setPlans(plans);
    }

    private static void setAddOns(Map<String, Object> map, PricingManager pricingManager) {
        Map addOnsMap = (Map)map.get("addOns");
        if (addOnsMap == null) {
            return;
        }
        pricingManager.setAddOns(new LinkedHashMap<String, AddOn>());
        for (String addOnName : addOnsMap.keySet()) {
            try {
                Map addOnMap = (Map)addOnsMap.get(addOnName);
                AddOn addOn = AddOnParser.parseMapToAddOn(addOnName, addOnMap, pricingManager);
                pricingManager.getAddOns().put(addOnName, addOn);
            }
            catch (ClassCastException e) {
                throw new PricingParsingException("An error has occurred while parsing the add-on " + addOnName + ". Error: " + e.getMessage());
            }
        }
        for (String addOnName : addOnsMap.keySet()) {
            try {
                AddOn parsedAddOn = pricingManager.getAddOns().get(addOnName);
                Map addOnMap = (Map)addOnsMap.get(addOnName);
                AddOnParser.setDependsOn(addOnMap, pricingManager, parsedAddOn);
                AddOnParser.setExcludes(addOnMap, pricingManager, parsedAddOn);
                pricingManager.getAddOns().put(addOnName, parsedAddOn);
            }
            catch (Exception e) {
                throw new PricingParsingException("An error has occurred while parsing the add-on " + addOnName + ". Error: " + e.getMessage());
            }
        }
    }
}

