/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.services.yaml;

import io.github.isagroup.exceptions.FilepathException;
import io.github.isagroup.exceptions.SerializerException;
import io.github.isagroup.exceptions.UpdateException;
import io.github.isagroup.models.PricingManager;
import io.github.isagroup.services.parsing.PricingManagerParser;
import io.github.isagroup.services.serializer.PricingManagerSerializer;
import io.github.isagroup.services.updaters.YamlUpdater;
import io.github.isagroup.services.yaml.SkipNullRepresenter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.representer.Representer;

public class YamlUtils {
    private static final String DEFAULT_YAML_WRITE_MAIN_PATH = "src/main/resources/";
    private static final String DEFAULT_YAML_WRITE_TEST_PATH = "src/test/resources/";

    private YamlUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static PricingManager retrieveManagerFromYaml(String receivedYamlPath) {
        Yaml yaml = new Yaml();
        try {
            String yamlPath = YamlUtils.getYamlPath(receivedYamlPath);
            String result = new String(Files.readAllBytes(Paths.get(yamlPath, new String[0])));
            Map configFile = (Map)yaml.load(result);
            YamlUpdater.update(configFile);
            return PricingManagerParser.parseMapToPricingManager(configFile);
        }
        catch (IOException e) {
            throw new FilepathException("Either the file path is invalid or the file does not exist.");
        }
        catch (UpdateException e) {
            YamlUtils.auxWriteYaml(e.getConfigFile());
            return null;
        }
    }

    public static void writeYaml(PricingManager pricingManager, String receivedYamlPath) {
        if (receivedYamlPath == null) {
            throw new FilepathException("Either the file path is invalid or the file does not exist.");
        }
        DumperOptions dump = new DumperOptions();
        dump.setIndent(2);
        dump.setPrettyFlow(true);
        dump.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        SkipNullRepresenter representer = new SkipNullRepresenter();
        PricingManagerSerializer pricingManagerSerializer = new PricingManagerSerializer();
        try {
            Object yamlPath = null;
            try {
                yamlPath = YamlUtils.getYamlPath(receivedYamlPath);
            }
            catch (IOException e) {
                yamlPath = DEFAULT_YAML_WRITE_MAIN_PATH + receivedYamlPath;
            }
            FileWriter writer = new FileWriter((String)yamlPath);
            Map<String, Object> serializedPricingManager = pricingManagerSerializer.serialize(pricingManager);
            Yaml yaml = new Yaml((Representer)representer, dump);
            yaml.dump(serializedPricingManager, (Writer)writer);
        }
        catch (IOException e) {
            throw new FilepathException("Either the file path is invalid or the file does not exist.");
        }
        catch (SerializerException e) {
            throw new SerializerException("An error occurred while serializing the PricingManager object.");
        }
    }

    private static void auxWriteYaml(Map<String, Object> configFile) {
        DumperOptions dump = new DumperOptions();
        dump.setIndent(2);
        dump.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        SkipNullRepresenter representer = new SkipNullRepresenter();
        try {
            FileWriter writer = new FileWriter("src/main/resources/yaml-testing/errored.yml");
            Yaml yaml = new Yaml((Representer)representer, dump);
            yaml.dump(configFile, (Writer)writer);
        }
        catch (IOException e) {
            throw new FilepathException("Either the file path is invalid or the file does not exist.");
        }
    }

    private static String getYamlPath(String receivedPath) throws IOException {
        if (!Files.exists(Paths.get(DEFAULT_YAML_WRITE_MAIN_PATH + receivedPath, new String[0]), new LinkOption[0])) {
            if (!Files.exists(Paths.get(DEFAULT_YAML_WRITE_TEST_PATH + receivedPath, new String[0]), new LinkOption[0])) {
                throw new IOException("Either the file path is invalid or the file does not exist.");
            }
            return DEFAULT_YAML_WRITE_TEST_PATH + receivedPath;
        }
        return DEFAULT_YAML_WRITE_MAIN_PATH + receivedPath;
    }
}

