/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup;

import io.github.isagroup.PricingContext;
import io.github.isagroup.exceptions.PricingPlanEvaluationException;
import io.github.isagroup.models.Feature;
import io.github.isagroup.models.FeatureStatus;
import io.github.isagroup.models.PlanContextManager;
import io.github.isagroup.models.PricingManager;
import io.github.isagroup.services.jwt.PricingJwtUtils;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.stereotype.Component;

@Component
public class PricingEvaluatorUtil {
    @Autowired
    private PricingJwtUtils jwtUtils;
    @Autowired
    private PricingContext pricingContext;
    Logger logger = Logger.getLogger(PricingEvaluatorUtil.class.getName());

    public PricingEvaluatorUtil(PricingContext pricingContext) {
        this.pricingContext = pricingContext;
        this.jwtUtils = new PricingJwtUtils(pricingContext);
    }

    public String generateUserToken() {
        HashMap<String, Map<String, Object>> claims = new HashMap<String, Map<String, Object>>();
        String subject = "Default";
        if (this.pricingContext.getUserContext().containsKey("username")) {
            subject = (String)this.pricingContext.getUserContext().get("username");
        } else if (this.pricingContext.getUserContext().containsKey("user")) {
            subject = (String)this.pricingContext.getUserContext().get("user");
        }
        PlanContextManager planContextManager = new PlanContextManager();
        try {
            planContextManager.setUserContext(this.pricingContext.getUserContext());
            claims.put("userContext", planContextManager.getUserContext());
        }
        catch (Exception e) {
            throw new PricingPlanEvaluationException("Error while retrieving user context! Please check your PricingContext.getUserContext() method");
        }
        if (!this.pricingContext.userAffectedByPricing().booleanValue()) {
            return Jwts.builder().setClaims(claims).setSubject(subject).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + (long)this.pricingContext.getJwtExpiration())).signWith(SignatureAlgorithm.HS512, this.pricingContext.getJwtSecret()).compact();
        }
        try {
            planContextManager.setPlanContext(this.pricingContext.getPlanContext());
        }
        catch (NullPointerException e) {
            throw new PricingPlanEvaluationException("Error while retrieving plan context! Please check your configuration file or add a plan with the given name");
        }
        PricingManager pricingManager = this.pricingContext.getPricingManager();
        Map<String, Feature> features = pricingManager.getFeatures();
        Map<String, FeatureStatus> featureStatuses = this.computeFeatureStatuses(planContextManager, features);
        claims.put("features", featureStatuses);
        claims.put("planContext", planContextManager.getPlanContext());
        return Jwts.builder().setClaims(claims).setSubject(subject).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + (long)this.pricingContext.getJwtExpiration())).signWith(SignatureAlgorithm.HS512, this.pricingContext.getJwtSecret()).compact();
    }

    private Map<String, FeatureStatus> computeFeatureStatuses(PlanContextManager planContextManager, Map<String, Feature> features) {
        HashMap<String, FeatureStatus> featureStatuses = new HashMap<String, FeatureStatus>();
        for (String featureName : features.keySet()) {
            FeatureStatus featureStatus = new FeatureStatus();
            Feature feature = features.get(featureName);
            String expression = features.get(featureName).getExpression();
            try {
                Boolean eval = FeatureStatus.computeFeatureEvaluation(expression, planContextManager).orElseThrow(() -> new PricingPlanEvaluationException("Evaluation was null"));
                featureStatus.setEval(eval);
            }
            catch (SpelEvaluationException e) {
                throw new PricingPlanEvaluationException("Error while evaluating the expression of the feature " + featureName + "! Please check the expression");
            }
            Optional<String> userContextKey = FeatureStatus.computeUserContextVariable(expression);
            if (!userContextKey.isPresent()) {
                featureStatus.setUsed(null);
                featureStatus.setLimit(null);
            } else {
                featureStatus.setUsed(planContextManager.getUserContext().get(userContextKey.get()));
                if (feature.getExpression().contains("usageLimits")) {
                    String usageLimitName = feature.getExpression().split("usageLimits")[1].split("[',\"]")[2];
                    featureStatus.setLimit(((Map)planContextManager.getPlanContext().get("usageLimits")).get(usageLimitName));
                } else {
                    featureStatus.setLimit(((Map)planContextManager.getPlanContext().get("features")).get(featureName));
                }
            }
            featureStatuses.put(featureName, featureStatus);
        }
        return featureStatuses;
    }

    public String addExpressionToToken(String token, String featureId, String expression) {
        Map<String, Map<String, Object>> features = this.jwtUtils.getFeaturesFromJwtToken(token);
        String subject = this.jwtUtils.getSubjectFromJwtToken(token);
        try {
            Map<String, Object> feature = features.get(featureId);
            feature.put("eval", expression);
        }
        catch (Exception e) {
            this.logger.warning("Feature not found");
        }
        return this.buildJwtToken(features, subject);
    }

    private String buildJwtToken(Map<String, Map<String, Object>> features, String subject) {
        HashMap<String, Map<String, Map<String, Object>>> claims = new HashMap<String, Map<String, Map<String, Object>>>();
        claims.put("features", features);
        claims.put("userContext", this.pricingContext.getUserContext());
        claims.put("planContext", this.pricingContext.getPlanContext());
        return Jwts.builder().setClaims(claims).setSubject(subject).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + (long)this.pricingContext.getJwtExpiration())).signWith(SignatureAlgorithm.HS512, this.pricingContext.getJwtSecret()).compact();
    }
}

