/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.services.updaters;

import io.github.isagroup.exceptions.UpdateException;
import io.github.isagroup.services.updaters.Updater;
import io.github.isagroup.services.updaters.Version;
import io.github.isagroup.services.updaters.VersionUpdater;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Map;

public class V10ToV11Updater
extends VersionUpdater {
    public V10ToV11Updater(Updater updater) {
        super(Version.V1_0, updater);
    }

    @Override
    public void update(Map<String, Object> configFile) throws UpdateException {
        configFile.put("version", "1.1");
        this.updateDayMonthYearToASingleField(configFile);
        this.removeSeverExpressionWhenBothExpressionAreEqual(configFile);
    }

    private void updateDayMonthYearToASingleField(Map<String, Object> configFile) throws UpdateException {
        ArrayList<String> errors = new ArrayList<String>();
        if (configFile.get("day") == null) {
            errors.add("day is mandatory");
        } else if (!(configFile.get("day") instanceof Integer)) {
            errors.add("day must be an integer");
        }
        if (configFile.get("month") == null) {
            errors.add("month is mandatory");
        } else if (!(configFile.get("month") instanceof Integer)) {
            errors.add("month must be an integer");
        }
        if (configFile.get("year") == null) {
            errors.add("year is mandatory");
        } else if (!(configFile.get("year") instanceof Integer)) {
            errors.add("year must be an integer");
        }
        if (!errors.isEmpty()) {
            throw new UpdateException(String.join((CharSequence)"\n", errors), configFile);
        }
        int day = (Integer)configFile.get("day");
        int month = (Integer)configFile.get("month");
        int year = (Integer)configFile.get("year");
        try {
            configFile.put("createdAt", LocalDate.of(year, month, day).toString());
            configFile.remove("day");
            configFile.remove("month");
            configFile.remove("year");
        }
        catch (DateTimeException e) {
            throw new UpdateException(e.getMessage(), configFile);
        }
    }

    private void removeSeverExpressionWhenBothExpressionAreEqual(Map<String, Object> configFile) throws UpdateException {
        if (configFile.get("features") instanceof Map) {
            this.removeServerExpressionFromFeatures((Map)configFile.get("features"));
        }
    }

    private void removeServerExpressionFromFeatures(Map<String, Object> features) throws UpdateException {
        for (Map.Entry<String, Object> feature : features.entrySet()) {
            if (!(feature.getValue() instanceof Map)) continue;
            this.modifyFeature((Map)feature.getValue());
        }
    }

    private void modifyFeature(Map<String, Object> attributes) {
        if (attributes.get("expression") != null && attributes.get("serverExpression") != null && attributes.get("expression").equals(attributes.get("serverExpression"))) {
            attributes.remove("serverExpression");
        }
    }
}

