/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.services.updaters;

import io.github.isagroup.exceptions.UpdateException;
import io.github.isagroup.services.updaters.Updater;
import io.github.isagroup.services.updaters.V10ToV11Updater;
import io.github.isagroup.services.updaters.V11ToV20Updater;
import io.github.isagroup.services.updaters.Version;
import java.util.LinkedHashMap;
import java.util.Map;

public class YamlUpdater {
    private static final Map<Version, Updater> updaters = new LinkedHashMap<Version, Updater>();

    public static void update(Map<String, Object> configFile) throws UpdateException {
        configFile.putIfAbsent("version", "1.0");
        Version version = Version.version(configFile.get("version"));
        if (updaters.get((Object)version) == null) {
            return;
        }
        updaters.get((Object)Version.V1_1).update(configFile);
    }

    static {
        updaters.put(Version.V1_0, new V10ToV11Updater(null));
        updaters.put(Version.V1_1, new V11ToV20Updater(updaters.get((Object)Version.V1_0)));
    }
}

