/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.utils;

import io.github.isagroup.exceptions.FeatureNotFoundException;
import io.github.isagroup.exceptions.InvalidDefaultValueException;
import io.github.isagroup.exceptions.InvalidValueTypeException;
import io.github.isagroup.models.AddOn;
import io.github.isagroup.models.Feature;
import io.github.isagroup.models.Plan;
import io.github.isagroup.models.PricingManager;
import io.github.isagroup.models.UsageLimit;
import io.github.isagroup.models.ValueType;
import java.util.List;
import java.util.stream.Collectors;

public class PricingValidators {
    public static void validateAndFormatFeature(Feature feature) {
        if (feature == null) {
            throw new IllegalArgumentException("A null feature cannot be added to the pricing configuration");
        }
        String item = "feature " + feature.getName();
        PricingValidators.validateName(feature.getName(), item);
        if (feature.getName().contains(" ")) {
            feature.setName(PricingValidators.parseStringToCamelCase(feature.getName()));
        }
        PricingValidators.validateValueType(feature.getValueType(), item);
        PricingValidators.validateDefaultValue(feature.getDefaultValue(), feature.getValueType(), item);
        PricingValidators.validateValue(feature.getValue(), feature.getValueType(), item);
        PricingValidators.validateExpression(feature.getExpression(), item);
        if (feature.getServerExpression() != null) {
            PricingValidators.validateExpression(feature.getServerExpression(), item);
        }
        PricingValidators.validateValueTypeConsistency(feature.getValueType(), feature.getDefaultValue(), feature.getValue(), feature.getExpression(), feature.getServerExpression(), item);
    }

    public static void validateAndFormatUsageLimit(PricingManager pricingManager, UsageLimit usageLimit) {
        if (usageLimit == null) {
            throw new IllegalArgumentException("A null usageLimit cannot be added to the pricing configuration");
        }
        String item = "usage limit " + usageLimit.getName();
        PricingValidators.validateName(usageLimit.getName(), item);
        if (usageLimit.getName().contains(" ")) {
            usageLimit.setName(PricingValidators.parseStringToCamelCase(usageLimit.getName()));
        }
        PricingValidators.validateValueType(usageLimit.getValueType(), item);
        PricingValidators.validateDefaultValue(usageLimit.getDefaultValue(), usageLimit.getValueType(), item);
        PricingValidators.validateUnit(usageLimit.getUnit(), item);
        PricingValidators.validateAllFeaturesExist(pricingManager, usageLimit.getLinkedFeatures());
    }

    public static void validateAndFormatPlan(PricingManager pricingManager, Plan plan) {
        if (plan == null) {
            throw new IllegalArgumentException("A null plan cannot be added to the pricing configuration");
        }
        String item = "plan " + plan.getName();
        PricingValidators.validateName(plan.getName(), item);
        if (plan.getName().contains(" ")) {
            plan.setName(PricingValidators.parseStringToCamelCase(plan.getName()));
        }
        PricingValidators.validatePlanPrice(plan);
        PricingValidators.validateUnit(plan.getUnit(), item);
        if (plan.getFeatures() != null) {
            PricingValidators.validateAllFeaturesExist(pricingManager, plan.getFeatures().keySet().stream().collect(Collectors.toList()));
            for (Feature feature : plan.getFeatures().values()) {
                PricingValidators.validateAndFormatFeature(feature);
            }
        }
        if (plan.getUsageLimits() != null) {
            PricingValidators.validateAllUsageLimitsExist(pricingManager, plan.getUsageLimits().keySet().stream().collect(Collectors.toList()), item);
            for (UsageLimit usageLimit : plan.getUsageLimits().values()) {
                PricingValidators.validateAndFormatUsageLimit(pricingManager, usageLimit);
            }
        }
    }

    public static void validateAndFormatAddOn(PricingManager pricingManager, AddOn addOn) {
        if (addOn == null) {
            throw new IllegalArgumentException("A null add on cannot be added to the pricing configuration");
        }
        String item = "add-on " + addOn.getName();
        PricingValidators.validateName(addOn.getName(), item);
        if (addOn.getName().contains(" ")) {
            addOn.setName(PricingValidators.parseStringToCamelCase(addOn.getName()));
        }
        PricingValidators.validateAddOnPrice(addOn, item);
        PricingValidators.validateUnit(addOn.getUnit(), item);
        if (addOn.getFeatures() != null) {
            PricingValidators.validateAllFeaturesExist(pricingManager, addOn.getFeatures().keySet().stream().collect(Collectors.toList()));
        }
        if (addOn.getUsageLimits() != null) {
            PricingValidators.validateAllUsageLimitsExist(pricingManager, addOn.getUsageLimits().keySet().stream().collect(Collectors.toList()), item);
        }
        if (addOn.getUsageLimitsExtensions() != null) {
            PricingValidators.validateAllUsageLimitsExist(pricingManager, addOn.getUsageLimitsExtensions().keySet().stream().collect(Collectors.toList()), item);
        }
    }

    private static void validateName(String name, String item) {
        if (name == null) {
            throw new IllegalArgumentException("The " + item + " name must not be null");
        }
        String trimmedName = name.trim();
        if (trimmedName.trim().isEmpty()) {
            throw new IllegalArgumentException("The " + item + " name must not be empty");
        }
        if (trimmedName.length() < 3) {
            throw new IllegalArgumentException("The " + item + " name must have at least 3 characters");
        }
        if (trimmedName.length() > 50) {
            throw new IllegalArgumentException("The " + item + " name must have at most 50 characters");
        }
    }

    private static void validatePlanPrice(Plan plan) {
        if (!PricingValidators.isValidPrice(plan.getPrice())) {
            throw new IllegalArgumentException("Invalid price type");
        }
    }

    private static void validateAddOnPrice(AddOn addOn, String item) {
        if (addOn.getPrice() == null) {
            throw new IllegalArgumentException("Either an " + item + " price or a monthlyPrice/annualPrice configuration must be specified");
        }
        if (addOn.getPrice() != null && !(addOn.getPrice() instanceof Double)) {
            throw new IllegalArgumentException("The " + item + " price must be a double");
        }
    }

    private static void validateValueType(ValueType valueType, String item) {
        if (valueType == null) {
            throw new InvalidValueTypeException("The " + item + " valueType must not be null");
        }
        if (valueType != ValueType.BOOLEAN && valueType != ValueType.NUMERIC && valueType != ValueType.TEXT) {
            throw new InvalidValueTypeException("The " + item + " valueType must be either BOOLEAN, NUMERIC or TEXT");
        }
    }

    private static void validateDefaultValue(Object defaultValue, ValueType valueType, String item) {
        if (defaultValue == null) {
            throw new InvalidDefaultValueException("The " + item + " defaultValue must not be null");
        }
        if (valueType == ValueType.BOOLEAN && !PricingValidators.isCondition(defaultValue)) {
            throw new InvalidDefaultValueException("The " + item + " defaultValue must be a boolean if valueType is BOOLEAN");
        }
        if (valueType == ValueType.NUMERIC && !PricingValidators.isNumeric(defaultValue)) {
            throw new InvalidDefaultValueException("The " + item + " defaultValue must be one of the supported numeric types if valueType is NUMERIC");
        }
        if (valueType == ValueType.TEXT && !PricingValidators.isText(defaultValue)) {
            throw new InvalidDefaultValueException("The " + item + " defaultValue must be a string if valueType is TEXT");
        }
    }

    private static void validateValue(Object value, ValueType valueType, String item) {
        if (value != null) {
            if (valueType == ValueType.BOOLEAN && !PricingValidators.isCondition(value)) {
                throw new IllegalArgumentException("The " + item + " value must be a boolean if valueType is BOOLEAN");
            }
            if (valueType == ValueType.NUMERIC && !PricingValidators.isNumeric(value)) {
                throw new IllegalArgumentException("The " + item + " value must be a one of the supported numeric types if valueType is NUMERIC");
            }
            if (valueType == ValueType.TEXT && !PricingValidators.isText(value)) {
                throw new IllegalArgumentException("The " + item + " value must be a string if valueType is TEXT");
            }
        }
    }

    private static void validateUnit(String unit, String item) {
        if (unit == null || unit.length() > 50) {
            throw new IllegalArgumentException("The " + item + " unit must have at most 10 characters and cannot be null");
        }
    }

    private static void validateAllFeaturesExist(PricingManager pricingManager, List<String> featureNames) {
        for (String featureName : featureNames) {
            if (pricingManager.getFeatures().containsKey(featureName)) continue;
            throw new FeatureNotFoundException("The feature " + featureName + " to which you're trying to attach an usage limit does not exist within the pricing");
        }
    }

    private static void validateAllUsageLimitsExist(PricingManager pricingManager, List<String> usageLimitNames, String item) {
        for (String usageLimitName : usageLimitNames) {
            if (pricingManager.getUsageLimits().containsKey(usageLimitName)) continue;
            throw new IllegalArgumentException("The usage limit " + usageLimitName + " to which you're trying to attach an " + item + " does not exist within the pricing");
        }
    }

    private static void validateExpression(String expression, String item) {
        if (!(expression instanceof String) || expression.length() > 1000) {
            throw new IllegalArgumentException("The " + item + " expression must have at most 1000 characters and must be a string");
        }
    }

    private static void validateValueTypeConsistency(ValueType valueType, Object defaultValue, Object value, String expression, String serverExpression, String item) {
        switch (valueType) {
            case BOOLEAN: {
                if (!PricingValidators.isCondition(defaultValue)) {
                    throw new InvalidDefaultValueException("The defaultValue of " + item + " must be a boolean if valueType is BOOLEAN");
                }
                if (value == null || PricingValidators.isCondition(value)) break;
                throw new IllegalArgumentException("The value of " + item + " must be a boolean if valueType is BOOLEAN");
            }
            case NUMERIC: {
                if (!PricingValidators.isNumeric(defaultValue)) {
                    throw new InvalidDefaultValueException("The defaultValue of " + item + " must be a numeric type if valueType is NUMERIC");
                }
                if (value != null && !PricingValidators.isNumeric(value)) {
                    throw new IllegalArgumentException("The value of " + item + " must be a numeric type if valueType is NUMERIC");
                }
                if (expression != null && !expression.matches(".*[<>=].*") && !expression.equals("")) {
                    throw new IllegalArgumentException("Expression of " + item + " should include comparison operators such as: <, > or ==, as it is NUMERIC");
                }
                if (serverExpression == null || serverExpression.matches(".*[<>=].*") || serverExpression.equals("")) break;
                throw new IllegalArgumentException("ServerExpression of " + item + " should include comparison operators such as: <, > or ==, as it is NUMERIC");
            }
            case TEXT: {
                if (!PricingValidators.isText(defaultValue)) {
                    throw new InvalidDefaultValueException("The defaultValue of " + item + " must be a string if valueType is TEXT");
                }
                if (value != null && !PricingValidators.isText(value)) {
                    throw new IllegalArgumentException("The value of " + item + " must be a string if valueType is TEXT");
                }
                if (expression != null && expression.matches(".*[<>&|].*")) {
                    throw new IllegalArgumentException("Expression of " + item + " should only include == or != operators, as it is TEXT");
                }
                if (serverExpression == null || !serverExpression.matches(".*[<>&|].*")) break;
                throw new IllegalArgumentException("ServerExpression of " + item + " should only include == or != operators, as it is TEXT");
            }
            default: {
                throw new IllegalArgumentException("The valueType must be one of the supported types (BOOLEAN, NUMERIC, TEXT)");
            }
        }
    }

    private static boolean isNumeric(Object value) {
        return value instanceof Integer || value instanceof Double || value instanceof Float || value instanceof Long || value instanceof Short || value instanceof Byte;
    }

    private static boolean isText(Object value) {
        return value instanceof String;
    }

    private static boolean isCondition(Object value) {
        return value instanceof Boolean;
    }

    private static String parseStringToCamelCase(String text) {
        String[] words = text.split(" ");
        Object camelCase = words[0].toLowerCase();
        for (int i = 1; i < words.length; ++i) {
            camelCase = (String)camelCase + words[i].substring(0, 1).toUpperCase() + words[i].substring(1).toLowerCase();
        }
        return camelCase;
    }

    private static boolean isValidPrice(Object price) {
        return price instanceof Double || price instanceof Long || price instanceof Integer || price instanceof String;
    }
}

