/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.models;

import io.github.isagroup.exceptions.CloneFeatureException;
import io.github.isagroup.models.ValueType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class Feature
implements Serializable {
    protected String name;
    protected String description;
    protected ValueType valueType;
    protected Object defaultValue;
    protected transient Object value;
    protected String expression;
    protected String serverExpression;
    protected String tag;

    public void prepareToPlanWriting() {
        this.name = null;
        this.value = null;
        this.description = null;
        this.defaultValue = null;
        this.expression = null;
        this.serverExpression = null;
        this.tag = null;
    }

    public boolean hasOverwrittenDefaultValue() {
        return !this.defaultValue.equals(this.value);
    }

    public Map<String, Object> featureAttributesMap() {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        if (this.description != null) {
            attributes.put("description", this.description);
        }
        if (this.valueType != null) {
            attributes.put("valueType", this.valueType.toString());
        }
        if (this.defaultValue != null) {
            attributes.put("defaultValue", this.defaultValue);
        }
        if (this.expression != null) {
            attributes.put("expression", this.expression);
        }
        if (this.serverExpression != null) {
            attributes.put("serverExpression", this.serverExpression);
        }
        if (this.tag != null) {
            attributes.put("tag", this.tag);
        }
        return attributes;
    }

    public abstract Map<String, Object> serializeFeature();

    public static Feature cloneFeature(Feature original) throws CloneFeatureException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(original);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return (Feature)objectInputStream.readObject();
        }
        catch (Exception e) {
            throw new CloneFeatureException("Error cloning feature");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Object getValue() {
        return this.value;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getServerExpression() {
        return this.serverExpression;
    }

    public String getTag() {
        return this.tag;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setServerExpression(String serverExpression) {
        this.serverExpression = serverExpression;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Feature)) {
            return false;
        }
        Feature other = (Feature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ValueType this$valueType = this.getValueType();
        ValueType other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !((Object)((Object)this$valueType)).equals((Object)other$valueType)) {
            return false;
        }
        Object this$defaultValue = this.getDefaultValue();
        Object other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        String this$serverExpression = this.getServerExpression();
        String other$serverExpression = other.getServerExpression();
        if (this$serverExpression == null ? other$serverExpression != null : !this$serverExpression.equals(other$serverExpression)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Feature;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ValueType $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : ((Object)((Object)$valueType)).hashCode());
        Object $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        String $serverExpression = this.getServerExpression();
        result = result * 59 + ($serverExpression == null ? 43 : $serverExpression.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        return result;
    }
}

