/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.services.parsing;

import io.github.isagroup.exceptions.FeatureNotFoundException;
import io.github.isagroup.exceptions.InvalidDefaultValueException;
import io.github.isagroup.exceptions.InvalidPlanException;
import io.github.isagroup.exceptions.PricingParsingException;
import io.github.isagroup.models.AddOn;
import io.github.isagroup.models.Feature;
import io.github.isagroup.models.PricingManager;
import io.github.isagroup.models.UsageLimit;
import io.github.isagroup.models.featuretypes.Payment;
import io.github.isagroup.services.parsing.PlanParser;
import io.github.isagroup.services.parsing.PricingManagerParser;
import io.github.isagroup.utils.PricingValidators;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AddOnParser {
    private AddOnParser() {
    }

    public static AddOn parseMapToAddOn(String addOnName, Map<String, Object> addOnMap, PricingManager pricingManager) {
        AddOn addOn = new AddOn();
        if (addOnName == null) {
            throw new PricingParsingException("An add on name cannot be null");
        }
        addOn.setName(addOnName);
        addOn.setDescription((String)addOnMap.get("description"));
        AddOnParser.setAvailableFor(addOnMap, pricingManager, addOn);
        if (addOnMap.get("private") != null) {
            if (!(addOnMap.get("private") instanceof Boolean)) {
                throw new PricingParsingException("The field \"private\" should be a boolean");
            }
            addOn.setIsPrivate((Boolean)addOnMap.get("private"));
        } else {
            addOn.setIsPrivate(false);
        }
        PricingValidators.checkPriceType(addOnMap.get("price"), addOnName);
        if (addOnMap.get("price") instanceof String && addOnMap.get("price").toString().contains("#")) {
            addOn.setPrice(PricingManagerParser.evaluateFormula(addOnMap.get("price").toString(), pricingManager));
        } else {
            addOn.setPrice(addOnMap.get("price"));
        }
        addOn.setUnit((String)addOnMap.get("unit"));
        if (addOnMap.get("features") == null) {
            addOn.setFeatures(null);
        } else {
            AddOnParser.setAddOnFeatures(addOnName, addOnMap, pricingManager, addOn);
        }
        if (addOnMap.get("usageLimits") == null) {
            addOn.setUsageLimits(null);
        } else {
            AddOnParser.setAddOnUsageLimits(addOnName, addOnMap, pricingManager, addOn, false);
        }
        if (addOnMap.get("usageLimitsExtensions") == null) {
            addOn.setUsageLimitsExtensions(null);
        } else {
            AddOnParser.setAddOnUsageLimits(addOnName, addOnMap, pricingManager, addOn, true);
        }
        return addOn;
    }

    private static void setAvailableFor(Map<String, Object> addOnMap, PricingManager pricingManager, AddOn addOn) {
        List plansAvailable = (List)addOnMap.get("availableFor");
        if (plansAvailable == null) {
            List<String> allPlans = pricingManager.getPlans().keySet().stream().toList();
            addOn.setAvailableFor(allPlans);
        }
        for (String planName : plansAvailable) {
            if (pricingManager.getPlans().containsKey(planName) || pricingManager.getAddOns().containsKey(planName)) continue;
            throw new InvalidPlanException("The plan or addOn " + planName + " is not defined in the pricing manager");
        }
        addOn.setAvailableFor(plansAvailable);
    }

    public static void setDependsOn(Map<String, Object> addOnMap, PricingManager pricingManager, AddOn addOn) {
        List dependsOn = (List)addOnMap.get("dependsOn");
        if (dependsOn == null) {
            return;
        }
        for (String addOnName : dependsOn) {
            if (pricingManager.getAddOns().containsKey(addOnName)) continue;
            throw new InvalidPlanException("The addOn " + addOnName + " is not defined in the pricing manager");
        }
        addOn.setDependsOn(dependsOn);
    }

    public static void setExcludes(Map<String, Object> addOnMap, PricingManager pricingManager, AddOn addOn) {
        List excludes = (List)addOnMap.get("excludes");
        if (excludes == null) {
            return;
        }
        for (String addOnName : excludes) {
            if (pricingManager.getAddOns().containsKey(addOnName)) continue;
            throw new InvalidPlanException("The addOn " + addOnName + " is not defined in the pricing manager");
        }
        addOn.setExcludes(excludes);
    }

    private static void setAddOnFeatures(String addOnName, Map<String, Object> addOnMap, PricingManager pricingManager, AddOn addOn) {
        Map addOnFeaturesMap = (Map)addOnMap.get("features");
        Map<String, Feature> globalFeaturesMap = pricingManager.getFeatures();
        HashMap<String, Feature> addOnFeatures = new HashMap<String, Feature>();
        if (addOnFeaturesMap == null) {
            return;
        }
        for (String addOnFeatureName : addOnFeaturesMap.keySet()) {
            Map addOnFeatureMap = (Map)addOnFeaturesMap.get(addOnFeatureName);
            if (!globalFeaturesMap.containsKey(addOnFeatureName)) {
                throw new FeatureNotFoundException("The feature " + addOnFeatureName + " is not defined in the global features");
            }
            Feature addOnFeature = Feature.cloneFeature(globalFeaturesMap.get(addOnFeatureName));
            switch (addOnFeature.getValueType()) {
                case NUMERIC: {
                    addOnFeature.setValue(addOnFeatureMap.get("value"));
                    if (addOnFeature.getValue() instanceof Integer || addOnFeature.getValue() instanceof Double || addOnFeature.getValue() instanceof Long) break;
                    throw new InvalidDefaultValueException("The feature " + addOnFeatureName + " does not have a valid value. Current valueType:" + addOnFeature.getValueType().toString() + "; Current defaultValue: " + addOnFeatureMap.get("value").toString());
                }
                case BOOLEAN: {
                    addOnFeature.setValue((boolean)((Boolean)addOnFeatureMap.get("value")));
                    break;
                }
                case TEXT: {
                    if (addOnFeature instanceof Payment) {
                        PlanParser.parsePaymentValue(addOnFeature, addOnFeatureName, addOnFeatureMap);
                        break;
                    }
                    addOnFeature.setValue((String)addOnFeatureMap.get("value"));
                }
            }
            addOnFeatures.put(addOnFeatureName, addOnFeature);
        }
        addOn.setFeatures(addOnFeatures);
    }

    private static void setAddOnUsageLimits(String addOnName, Map<String, Object> addOnMap, PricingManager pricingManager, AddOn addOn, boolean areExtensions) {
        Map addOnUsageLimitsMap = null;
        addOnUsageLimitsMap = areExtensions ? (Map)addOnMap.get("usageLimitsExtensions") : (Map)addOnMap.get("usageLimits");
        Map<String, UsageLimit> globalUsageLimitsMap = pricingManager.getUsageLimits();
        HashMap<String, UsageLimit> addOnUsageLimits = new HashMap<String, UsageLimit>();
        if (addOnUsageLimitsMap == null) {
            return;
        }
        for (String addOnUsageLimitName : addOnUsageLimitsMap.keySet()) {
            Map addOnUsageLimitMap = new HashMap();
            try {
                addOnUsageLimitMap = (Map)addOnUsageLimitsMap.get(addOnUsageLimitName);
            }
            catch (ClassCastException e) {
                throw new PricingParsingException("The usage limit " + addOnUsageLimitName + " of the add-on " + addOnName + " is not a valid map. Maybe 'value' attribute is missing to set the value of the limit");
            }
            if (!globalUsageLimitsMap.containsKey(addOnUsageLimitName)) {
                throw new FeatureNotFoundException("The feature " + addOnUsageLimitName + " is not defined in the global features");
            }
            UsageLimit addOnUsageLimit = UsageLimit.cloneUsageLimit(globalUsageLimitsMap.get(addOnUsageLimitName));
            switch (addOnUsageLimit.getValueType()) {
                case NUMERIC: {
                    addOnUsageLimit.setValue(addOnUsageLimitMap.get("value"));
                    if (addOnUsageLimit.getValue() instanceof Integer || addOnUsageLimit.getValue() instanceof Double || addOnUsageLimit.getValue() instanceof Long) break;
                    throw new InvalidDefaultValueException("The feature " + addOnUsageLimitName + " does not have a valid value. Current valueType:" + addOnUsageLimit.getValueType().toString() + "; Current defaultValue: " + addOnUsageLimitMap.get("value").toString());
                }
                case BOOLEAN: {
                    addOnUsageLimit.setValue((boolean)((Boolean)addOnUsageLimitMap.get("value")));
                    break;
                }
                case TEXT: {
                    addOnUsageLimit.setValue((String)addOnUsageLimitMap.get("value"));
                }
            }
            addOnUsageLimits.put(addOnUsageLimitName, addOnUsageLimit);
        }
        if (areExtensions) {
            addOn.setUsageLimitsExtensions(addOnUsageLimits);
        } else {
            addOn.setUsageLimits(addOnUsageLimits);
        }
    }

    private static boolean isValidPrice(Object price) {
        return price instanceof Double || price instanceof Long || price instanceof Integer || price instanceof String;
    }
}

