/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.models;

import io.github.isagroup.exceptions.CloneUsageLimitException;
import io.github.isagroup.models.UsageLimitType;
import io.github.isagroup.models.ValueType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class UsageLimit
implements Serializable {
    private String name;
    private String description;
    private ValueType valueType;
    private Object defaultValue;
    protected UsageLimitType type;
    private String unit;
    private transient Object value;
    private List<String> linkedFeatures = new ArrayList<String>();
    private String expression;
    private String serverExpression;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public UsageLimitType getType() {
        return this.type;
    }

    public void setType(UsageLimitType type) {
        this.type = type;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public List<String> getLinkedFeatures() {
        return this.linkedFeatures;
    }

    public void setLinkedFeatures(List<String> linkedFeatures) {
        this.linkedFeatures = linkedFeatures;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getServerExpression() {
        return this.serverExpression;
    }

    public void setServerExpression(String serverExpression) {
        this.serverExpression = serverExpression;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.valueType == null ? 0 : this.valueType.hashCode());
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.linkedFeatures == null ? 0 : this.linkedFeatures.hashCode());
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.serverExpression == null ? 0 : this.serverExpression.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UsageLimit other = (UsageLimit)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.valueType != other.valueType) {
            return false;
        }
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.unit == null ? other.unit != null : !this.unit.equals(other.unit)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        if (this.linkedFeatures == null ? other.linkedFeatures != null : !this.linkedFeatures.equals(other.linkedFeatures)) {
            return false;
        }
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        return !(this.serverExpression == null ? other.serverExpression != null : !this.serverExpression.equals(other.serverExpression));
    }

    public String toString() {
        return "UsageLimit [name=" + this.name + ", description=" + this.description + ", valueType=" + String.valueOf((Object)this.valueType) + ", defaultValue=" + String.valueOf(this.defaultValue) + ", type=" + String.valueOf((Object)this.type) + ", unit=" + this.unit + ", linkedFeatures=" + String.valueOf(this.linkedFeatures) + ", expression=" + this.expression + ", serverExpression=" + this.serverExpression + "]";
    }

    public boolean isLinkedToFeature(String featureName) {
        return this.linkedFeatures.contains(featureName);
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        if (this.description != null) {
            attributes.put("description", this.description);
        }
        if (this.valueType != null) {
            attributes.put("valueType", this.valueType.toString());
        }
        if (this.defaultValue != null) {
            attributes.put("defaultValue", this.defaultValue);
        }
        if (this.unit != null) {
            attributes.put("unit", this.unit);
        }
        attributes.put("type", this.type.toString());
        if (this.linkedFeatures != null && !this.linkedFeatures.isEmpty()) {
            attributes.put("linkedFeatures", this.linkedFeatures);
        }
        if (this.expression != null) {
            attributes.put("expression", this.expression);
        }
        if (this.serverExpression != null) {
            attributes.put("serverExpression", this.serverExpression);
        }
        return attributes;
    }

    public static UsageLimit cloneUsageLimit(UsageLimit original) throws CloneUsageLimitException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(original);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return (UsageLimit)objectInputStream.readObject();
        }
        catch (Exception e) {
            throw new CloneUsageLimitException("Error cloning usageLimit");
        }
    }
}

