/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup;

import io.github.isagroup.exceptions.PricingPlanEvaluationException;
import io.github.isagroup.models.AddOn;
import io.github.isagroup.models.Feature;
import io.github.isagroup.models.Plan;
import io.github.isagroup.models.PricingManager;
import io.github.isagroup.models.UsageLimit;
import io.github.isagroup.services.yaml.YamlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.yaml.snakeyaml.error.YAMLException;

@Component
public abstract class PricingContext {
    private static final Logger logger = LoggerFactory.getLogger(PricingContext.class);

    public abstract String getConfigFilePath();

    public abstract String getJwtSecret();

    public String getAuthJwtSecret() {
        return this.getJwtSecret();
    }

    public int getJwtExpiration() {
        return 86400000;
    }

    public Boolean userAffectedByPricing() {
        return true;
    }

    public abstract Map<String, Object> getUserContext();

    public abstract String getUserPlan();

    public abstract List<String> getUserAddOns();

    public final Map<String, Object> getUserSubscription() {
        HashMap<String, Object> userSubscription = new HashMap<String, Object>();
        userSubscription.put("plan", this.getUserPlan());
        userSubscription.put("addOns", this.getUserAddOns());
        return userSubscription;
    }

    public final Map<String, Object> getPlanContext() {
        Plan plan = this.getPricingManager().getPlans().get(this.getUserPlan());
        Map<String, AddOn> addOnsMap = this.getPricingManager().getAddOns();
        ArrayList<AddOn> addOns = new ArrayList<AddOn>();
        for (String addOnName : this.getUserAddOns()) {
            AddOn addOn = addOnsMap.get(addOnName);
            if (addOn != null) {
                addOns.add(addOn);
                continue;
            }
            logger.warn("[WARNING] User add-on {} not found in the pricing configuration. It hasn't been considered in feature evaluation.", (Object)addOnName);
        }
        HashMap<String, Object> planContext = new HashMap<String, Object>();
        Map<String, Object> planFeaturesContext = this.computeFeatureValueMap(plan, addOns);
        planContext.put("features", planFeaturesContext);
        Map<String, Object> planUsageLimitMap = this.computeUsageLimitValueMap(plan, addOns);
        planContext.put("usageLimits", planUsageLimitMap);
        return planContext;
    }

    public final PricingManager getPricingManager() {
        try {
            return YamlUtils.retrieveManagerFromYaml(this.getConfigFilePath());
        }
        catch (YAMLException e) {
            throw new PricingPlanEvaluationException("Error while parsing YAML file");
        }
    }

    private final Map<String, Object> computeFeatureValueMap(Plan plan, List<AddOn> addOns) {
        HashMap<String, Object> featureValueMap = new HashMap<String, Object>();
        featureValueMap.putAll(plan.getFeatures().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Feature)e.getValue()).getValue() != null ? ((Feature)e.getValue()).getValue() : ((Feature)e.getValue()).getDefaultValue())));
        for (AddOn addOn : addOns) {
            try {
                Map<String, Feature> addOnFeatures = addOn.getFeatures();
                if (addOnFeatures == null) continue;
                featureValueMap.putAll(addOnFeatures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Feature)e.getValue()).getValue())));
            }
            catch (NullPointerException e2) {
                throw new PricingPlanEvaluationException("Error while creating evaluation context. Add-on " + addOn.getName() + " do not have a value for all its features.");
            }
        }
        return featureValueMap;
    }

    private final Map<String, Object> computeUsageLimitValueMap(Plan plan, List<AddOn> addOns) {
        HashMap<String, Object> usageLimitMap = new HashMap<String, Object>();
        usageLimitMap.putAll(plan.getUsageLimits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((UsageLimit)e.getValue()).getValue() != null ? ((UsageLimit)e.getValue()).getValue() : ((UsageLimit)e.getValue()).getDefaultValue())));
        for (AddOn addOn : addOns) {
            try {
                Map<String, UsageLimit> addOnUsageLimits = addOn.getUsageLimits();
                if (addOnUsageLimits == null) continue;
                usageLimitMap.putAll(addOnUsageLimits.entrySet().stream().collect(Collectors.toMap(e -> ((UsageLimit)e.getValue()).getName(), e -> ((UsageLimit)e.getValue()).getValue())));
            }
            catch (NullPointerException e2) {
                throw new PricingPlanEvaluationException("Error while creating evaluation context. Add-on " + addOn.getName() + " do not have a value for all its features.");
            }
        }
        for (AddOn addOn : addOns) {
            try {
                Map<String, UsageLimit> addOnUsageLimitsExtensions = addOn.getUsageLimitsExtensions();
                if (addOnUsageLimitsExtensions == null) continue;
                usageLimitMap.putAll(addOnUsageLimitsExtensions.entrySet().stream().collect(Collectors.toMap(e -> ((UsageLimit)e.getValue()).getName(), e -> {
                    Number existingValue = (Number)usageLimitMap.get(((UsageLimit)e.getValue()).getName());
                    Number extensionValue = (Number)((UsageLimit)e.getValue()).getValue();
                    if (existingValue == null || extensionValue == null) {
                        throw new PricingPlanEvaluationException("Error while creating evaluation context. Usage limit extension values must be numeric and not null.");
                    }
                    return existingValue.doubleValue() + extensionValue.doubleValue();
                })));
            }
            catch (NullPointerException e3) {
                throw new PricingPlanEvaluationException("Error while creating evaluation context. It wasn't possible to extend the add-on " + addOn.getName() + ". Please check that the usage limit that youre trying to extend actually exists in the configuration and that it's NUMERIC.");
            }
        }
        return usageLimitMap;
    }
}

