/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup;

import io.github.isagroup.PricingContext;
import io.github.isagroup.exceptions.CloneUsageLimitException;
import io.github.isagroup.models.AddOn;
import io.github.isagroup.models.Feature;
import io.github.isagroup.models.Plan;
import io.github.isagroup.models.PricingManager;
import io.github.isagroup.models.UsageLimit;
import io.github.isagroup.models.ValueType;
import io.github.isagroup.services.yaml.YamlUtils;
import io.github.isagroup.utils.PricingValidators;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PricingService {
    @Autowired
    private PricingContext pricingContext;
    private final Map<ValueType, Object> DEFAULT_VALUES = new HashMap<ValueType, Object>();

    public PricingService(PricingContext pricingContext) {
        this.pricingContext = pricingContext;
        this.DEFAULT_VALUES.put(ValueType.BOOLEAN, false);
        this.DEFAULT_VALUES.put(ValueType.NUMERIC, 0);
        this.DEFAULT_VALUES.put(ValueType.TEXT, "");
    }

    public Map<String, Feature> getPricingFeatures() {
        PricingManager pricingManager = this.pricingContext.getPricingManager();
        return pricingManager.getFeatures();
    }

    public Map<String, UsageLimit> getPricingUsageLimits() {
        PricingManager pricingManager = this.pricingContext.getPricingManager();
        return pricingManager.getUsageLimits();
    }

    public Map<String, Plan> getPricingPlans() {
        PricingManager pricingManager = this.pricingContext.getPricingManager();
        return pricingManager.getPlans();
    }

    public Map<String, AddOn> getPricingAddOns() {
        PricingManager pricingManager = this.pricingContext.getPricingManager();
        return pricingManager.getAddOns();
    }

    public Plan getPlanFromName(String planName) {
        PricingManager pricingManager = YamlUtils.retrieveManagerFromYaml(this.pricingContext.getConfigFilePath());
        Plan plan = pricingManager.getPlans().get(planName);
        if (plan == null) {
            throw new IllegalArgumentException("The plan " + planName + " does not exist in the current pricing configuration");
        }
        return plan;
    }

    @Transactional
    public void addPlanToConfiguration(Plan plan) {
        PricingManager pricingManager = YamlUtils.retrieveManagerFromYaml(this.pricingContext.getConfigFilePath());
        Map<String, Plan> plans = pricingManager.getPlans();
        if (plans.containsKey(plan.getName())) {
            throw new IllegalArgumentException("The plan " + plan.getName() + " already exists in the current pricing configuration");
        }
        PricingValidators.validateAndFormatPlan(pricingManager, plan);
        plans.put(plan.getName(), plan);
        pricingManager.setPlans(plans);
        YamlUtils.writeYaml(pricingManager, this.pricingContext.getConfigFilePath());
    }

    @Transactional
    public void addFeatureToConfiguration(Feature feature) {
        PricingManager pricingManager = YamlUtils.retrieveManagerFromYaml(this.pricingContext.getConfigFilePath());
        Map<String, Feature> features = pricingManager.getFeatures();
        if (features.containsKey(feature.getName())) {
            throw new IllegalArgumentException("The feature " + feature.getName() + " does already exist in the current pricing configuration. Check the features");
        }
        PricingValidators.validateAndFormatFeature(feature);
        feature.setValue(null);
        features.put(feature.getName(), feature);
        pricingManager.setFeatures(features);
        YamlUtils.writeYaml(pricingManager, this.pricingContext.getConfigFilePath());
    }

    @Transactional
    public void updateFeatureFromConfiguration(String previousName, Feature feature) {
        boolean valueTypeConsistencyHasChanged;
        PricingManager pricingManager = YamlUtils.retrieveManagerFromYaml(this.pricingContext.getConfigFilePath());
        Map<String, Feature> features = pricingManager.getFeatures();
        Map<String, UsageLimit> usageLimits = pricingManager.getUsageLimits();
        Map<String, Plan> plans = pricingManager.getPlans();
        Map<String, AddOn> addOns = pricingManager.getAddOns();
        PricingValidators.validateAndFormatFeature(feature);
        if (!features.containsKey(previousName)) {
            throw new IllegalArgumentException("There is no feature with the name " + previousName + " in the current pricing configuration");
        }
        boolean nameHasChanged = !previousName.equals(feature.getName());
        boolean bl = valueTypeConsistencyHasChanged = features.get(previousName).getValueType() != feature.getValueType() || features.get(previousName).getDefaultValue() != feature.getDefaultValue();
        if (nameHasChanged) {
            features.remove(previousName);
        }
        features.put(feature.getName(), feature);
        Map<String, UsageLimit> newUsageLimits = nameHasChanged ? this.updateUsageLimitsWithUpdatedFeature(previousName, feature, usageLimits) : usageLimits;
        Map<String, Plan> newPlans = nameHasChanged || valueTypeConsistencyHasChanged ? this.removeFeatureFromPlans(previousName, pricingManager) : plans;
        Map<String, AddOn> newAddOns = nameHasChanged || valueTypeConsistencyHasChanged ? this.removeFeatureFromAddOns(previousName, pricingManager) : addOns;
        pricingManager.setFeatures(features);
        pricingManager.setUsageLimits(newUsageLimits);
        pricingManager.setPlans(newPlans);
        pricingManager.setAddOns(newAddOns);
        YamlUtils.writeYaml(pricingManager, this.pricingContext.getConfigFilePath());
    }

    @Transactional
    public void updatePlanFromConfiguration(String previousName, Plan plan) {
        PricingManager pricingManager = YamlUtils.retrieveManagerFromYaml(this.pricingContext.getConfigFilePath());
        Map<String, Plan> plans = pricingManager.getPlans();
        if (!plans.containsKey(previousName)) {
            throw new IllegalArgumentException("There is no plan with the name " + previousName + " in the current pricing configuration");
        }
        PricingValidators.validateAndFormatPlan(pricingManager, plan);
        if (!previousName.equals(plan.getName())) {
            plans.remove(previousName);
        }
        plans.put(plan.getName(), plan);
        pricingManager.setPlans(plans);
        this.updateAddOnsWithNewPlan(previousName, plan.getName(), pricingManager);
        YamlUtils.writeYaml(pricingManager, this.pricingContext.getConfigFilePath());
    }

    @Transactional
    public void setPricingConfiguration(PricingManager pricingManager) {
        YamlUtils.writeYaml(pricingManager, this.pricingContext.getConfigFilePath());
    }

    @Transactional
    public void removePlanFromConfiguration(String name) {
        PricingManager pricingManager = YamlUtils.retrieveManagerFromYaml(this.pricingContext.getConfigFilePath());
        Map<String, Plan> plans = pricingManager.getPlans();
        if (!plans.containsKey(name)) {
            throw new IllegalArgumentException("There is no plan with the name " + name + " in the current pricing configuration");
        }
        plans.remove(name);
        pricingManager.setPlans(plans);
        this.removePlanFromAddOns(name, pricingManager);
        YamlUtils.writeYaml(pricingManager, this.pricingContext.getConfigFilePath());
    }

    @Transactional
    public void removeFeatureFromConfiguration(String name) {
        PricingManager pricingManager = YamlUtils.retrieveManagerFromYaml(this.pricingContext.getConfigFilePath());
        Map<String, Feature> features = pricingManager.getFeatures();
        if (!features.containsKey(name)) {
            throw new IllegalArgumentException("There is no feature with the name " + name + " in the current pricing configuration");
        }
        if (features.keySet().size() == 1) {
            throw new IllegalStateException("You cannot delete a feature from a one-feature pricing configuration");
        }
        features.remove(name);
        Map<String, UsageLimit> newUsageLimits = this.removeFeatureFromUsageLimits(name, pricingManager);
        Map<String, Plan> newPlans = this.removeFeatureFromPlans(name, pricingManager);
        Map<String, AddOn> newAddOns = this.removeFeatureFromAddOns(name, pricingManager);
        pricingManager.setFeatures(features);
        if (newUsageLimits == null || newUsageLimits.isEmpty()) {
            pricingManager.setUsageLimits(null);
        } else {
            pricingManager.setUsageLimits(newUsageLimits);
        }
        if (newPlans == null || newPlans.isEmpty()) {
            pricingManager.setPlans(null);
        } else {
            pricingManager.setPlans(newPlans);
        }
        if (newAddOns == null || newAddOns.isEmpty()) {
            pricingManager.setAddOns(null);
        } else {
            pricingManager.setAddOns(newAddOns);
        }
        YamlUtils.writeYaml(pricingManager, this.pricingContext.getConfigFilePath());
    }

    @Transactional
    public void addUsageLimitToConfiguration(UsageLimit usageLimit) {
        PricingManager pricingManager = this.pricingContext.getPricingManager();
        Map<String, UsageLimit> usageLimits = pricingManager.getUsageLimits();
        PricingValidators.validateAndFormatUsageLimit(pricingManager, usageLimit);
        if (pricingManager.getUsageLimits().containsKey(usageLimit.getName())) {
            throw new CloneUsageLimitException("An usage limit with the name " + usageLimit.getName() + " already exists within the pricing configuration");
        }
        usageLimits.put(usageLimit.getName(), usageLimit);
        pricingManager.setUsageLimits(usageLimits);
        YamlUtils.writeYaml(pricingManager, this.pricingContext.getConfigFilePath());
    }

    @Transactional
    public void updateUsageLimitFromConfiguration(String previousUsageLimitName, UsageLimit usageLimit) {
        PricingManager pricingManager = YamlUtils.retrieveManagerFromYaml(this.pricingContext.getConfigFilePath());
        Map<String, UsageLimit> usageLimits = pricingManager.getUsageLimits();
        List usageLimitsNames = usageLimits.keySet().stream().collect(Collectors.toList());
        if (!usageLimitsNames.contains(previousUsageLimitName)) {
            throw new IllegalArgumentException("There is no usage limit with the name " + previousUsageLimitName + " in the current pricing configuration");
        }
        PricingValidators.validateAndFormatUsageLimit(pricingManager, usageLimit);
        if (usageLimit.getValueType() != usageLimits.get(usageLimit.getName()).getValueType() || usageLimit.getDefaultValue() != usageLimits.get(usageLimit.getName()).getDefaultValue()) {
            Map<String, Plan> plans = pricingManager.getPlans();
            for (Map.Entry<String, Plan> planEntry : plans.entrySet()) {
                planEntry.getValue().getUsageLimits().remove(previousUsageLimitName);
            }
        }
        if (!previousUsageLimitName.equals(usageLimit.getName())) {
            usageLimits.remove(previousUsageLimitName);
        }
        usageLimits.put(usageLimit.getName(), usageLimit);
        pricingManager.setUsageLimits(usageLimits);
        YamlUtils.writeYaml(pricingManager, this.pricingContext.getConfigFilePath());
    }

    @Transactional
    public void removeUsageLimitFromConfiguration(String name) {
        PricingManager pricingManager = YamlUtils.retrieveManagerFromYaml(this.pricingContext.getConfigFilePath());
        Map<String, UsageLimit> usageLimits = pricingManager.getUsageLimits();
        if (!usageLimits.containsKey(name)) {
            throw new IllegalArgumentException("There is no usage limit with the name " + name + " in the current pricing configuration");
        }
        usageLimits.remove(name);
        pricingManager.setUsageLimits(usageLimits);
        YamlUtils.writeYaml(pricingManager, this.pricingContext.getConfigFilePath());
    }

    @Transactional
    public void addAddOnToConfiguration(AddOn addOn) {
        PricingManager pricingManager = YamlUtils.retrieveManagerFromYaml(this.pricingContext.getConfigFilePath());
        PricingValidators.validateAndFormatAddOn(pricingManager, addOn);
        Map<String, AddOn> addOns = pricingManager.getAddOns();
        if (addOns == null) {
            addOns = new HashMap<String, AddOn>();
        }
        if (addOns.containsKey(addOn.getName())) {
            throw new IllegalArgumentException("An add-on with the name " + addOn.getName() + " already exists within the pricing configuration");
        }
        addOns.put(addOn.getName(), addOn);
        pricingManager.setAddOns(addOns);
        YamlUtils.writeYaml(pricingManager, this.pricingContext.getConfigFilePath());
    }

    @Transactional
    public void updateAddOnFromConfiguration(String previousName, AddOn addOn) {
        PricingManager pricingManager = YamlUtils.retrieveManagerFromYaml(this.pricingContext.getConfigFilePath());
        List addOnsNames = pricingManager.getAddOns().keySet().stream().collect(Collectors.toList());
        if (!addOnsNames.contains(previousName)) {
            throw new IllegalArgumentException("There is no add-on with the name " + previousName + " in the current pricing configuration");
        }
        PricingValidators.validateAndFormatAddOn(pricingManager, addOn);
        Map<String, AddOn> addOns = pricingManager.getAddOns();
        if (!previousName.equals(addOn.getName())) {
            addOns.remove(previousName);
        }
        addOns.put(addOn.getName(), addOn);
        pricingManager.setAddOns(addOns);
        YamlUtils.writeYaml(pricingManager, this.pricingContext.getConfigFilePath());
    }

    @Transactional
    public void removeAddOnFromConfiguration(String addOnName) {
        PricingManager pricingManager = YamlUtils.retrieveManagerFromYaml(this.pricingContext.getConfigFilePath());
        Map<String, AddOn> addOns = pricingManager.getAddOns();
        if (!addOns.containsKey(addOnName)) {
            throw new IllegalArgumentException("There is no add-on with the name " + addOnName + " in the current pricing configuration");
        }
        addOns.remove(addOnName);
        pricingManager.setAddOns(addOns);
        YamlUtils.writeYaml(pricingManager, this.pricingContext.getConfigFilePath());
    }

    private Map<String, UsageLimit> updateUsageLimitsWithUpdatedFeature(String previousName, Feature feature, Map<String, UsageLimit> usageLimits) {
        for (UsageLimit usageLimit : usageLimits.values()) {
            if (!usageLimit.isLinkedToFeature(previousName)) continue;
            usageLimit.getLinkedFeatures().remove(previousName);
            usageLimit.getLinkedFeatures().add(feature.getName());
        }
        return usageLimits;
    }

    private Map<String, UsageLimit> removeFeatureFromUsageLimits(String featureName, PricingManager pricingManager) {
        Map<String, UsageLimit> usageLimits = pricingManager.getUsageLimits();
        ArrayList<String> usageLimitsToRemove = new ArrayList<String>();
        if (usageLimits == null) {
            return usageLimits;
        }
        for (UsageLimit usageLimit : usageLimits.values()) {
            if (!usageLimit.isLinkedToFeature(featureName)) continue;
            List<String> newLinkedFeatures = usageLimit.getLinkedFeatures().stream().filter(name -> !name.equals(featureName)).collect(Collectors.toList());
            usageLimit.setLinkedFeatures(newLinkedFeatures.isEmpty() ? null : newLinkedFeatures);
            if (usageLimit.getLinkedFeatures() == null) {
                usageLimitsToRemove.add(usageLimit.getName());
                continue;
            }
            usageLimits.put(usageLimit.getName(), usageLimit);
        }
        usageLimitsToRemove.forEach(usageLimits::remove);
        this.removeUsageLimitsFromPlans(usageLimitsToRemove, pricingManager);
        this.removeUsageLimitsFromAddOns(usageLimitsToRemove, pricingManager);
        return usageLimits;
    }

    private Map<String, Plan> removeFeatureFromPlans(String featureName, PricingManager pricingManager) {
        Map<String, Plan> plans = pricingManager.getPlans();
        ArrayList<String> plansToRemove = new ArrayList<String>();
        if (plans == null) {
            return plans;
        }
        for (String planName : plans.keySet()) {
            Plan plan = plans.get(planName);
            Map<String, Feature> planFeatures = plan.getFeatures();
            if (!planFeatures.containsKey(featureName)) continue;
            planFeatures.remove(featureName);
            if (planFeatures.isEmpty()) {
                plansToRemove.add(planName);
                continue;
            }
            plan.setFeatures(planFeatures);
            plans.put(planName, plan);
        }
        plansToRemove.forEach(plans::remove);
        return plans;
    }

    private Map<String, AddOn> removeFeatureFromAddOns(String featureName, PricingManager pricingManager) {
        Map<String, AddOn> addOns = pricingManager.getAddOns();
        ArrayList<String> addOnsToRemove = new ArrayList<String>();
        if (addOns == null) {
            return addOns;
        }
        for (String addOnName : addOns.keySet()) {
            AddOn addOn = addOns.get(addOnName);
            Map<String, Feature> addOnFeatures = addOn.getFeatures();
            if (addOnFeatures == null || !addOnFeatures.containsKey(featureName)) continue;
            addOnFeatures.remove(featureName);
            if (addOnFeatures.isEmpty()) {
                addOnsToRemove.add(addOnName);
                continue;
            }
            addOn.setFeatures(addOnFeatures);
            addOns.put(addOnName, addOn);
        }
        addOnsToRemove.forEach(addOns::remove);
        return addOns;
    }

    private void removeUsageLimitsFromPlans(List<String> usageLimitsToRemove, PricingManager pricingManager) {
        Map<String, Plan> plans = pricingManager.getPlans();
        if (plans == null) {
            return;
        }
        for (Plan plan : plans.values()) {
            for (String usageLimitName : usageLimitsToRemove) {
                plan.getUsageLimits().remove(usageLimitName);
            }
        }
        pricingManager.setPlans(plans);
    }

    private void removeUsageLimitsFromAddOns(List<String> usageLimitsToRemove, PricingManager pricingManager) {
        Map<String, AddOn> addOns = pricingManager.getAddOns();
        if (addOns == null) {
            return;
        }
        for (AddOn addOn : addOns.values()) {
            for (String usageLimitName : usageLimitsToRemove) {
                if (addOn.getUsageLimits() != null && addOn.getUsageLimits().get(usageLimitName) != null) {
                    addOn.getUsageLimits().remove(usageLimitName);
                }
                if (addOn.getUsageLimitsExtensions() == null || addOn.getUsageLimitsExtensions().get(usageLimitName) == null) continue;
                addOn.getUsageLimitsExtensions().remove(usageLimitName);
            }
        }
        pricingManager.setAddOns(addOns);
    }

    private void removePlanFromAddOns(String planName, PricingManager pricingManager) {
        Map<String, AddOn> addOns = pricingManager.getAddOns();
        if (addOns == null) {
            return;
        }
        for (AddOn addOn : addOns.values()) {
            if (addOn.getAvailableFor() != null && addOn.getAvailableFor().contains(planName)) {
                addOn.getAvailableFor().remove(planName);
            }
            if (!addOn.getAvailableFor().isEmpty()) continue;
            addOns.remove(addOn.getName());
        }
        pricingManager.setAddOns(addOns);
    }

    private void updateAddOnsWithNewPlan(String previousName, String newName, PricingManager pricingManager) {
        Map<String, AddOn> addOns = pricingManager.getAddOns();
        if (addOns == null) {
            return;
        }
        for (AddOn addOn : addOns.values()) {
            if (addOn.getAvailableFor() == null || !addOn.getAvailableFor().contains(previousName)) continue;
            addOn.getAvailableFor().remove(previousName);
            addOn.getAvailableFor().add(newName);
        }
        pricingManager.setAddOns(addOns);
    }
}

