/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.services.parsing;

import io.github.isagroup.exceptions.InvalidDefaultValueException;
import io.github.isagroup.exceptions.InvalidLinkedFeatureException;
import io.github.isagroup.exceptions.InvalidValueTypeException;
import io.github.isagroup.exceptions.PricingParsingException;
import io.github.isagroup.models.PricingManager;
import io.github.isagroup.models.UsageLimit;
import io.github.isagroup.models.UsageLimitType;
import io.github.isagroup.models.ValueType;
import io.github.isagroup.models.usagelimittypes.NonRenewable;
import io.github.isagroup.models.usagelimittypes.Renewable;
import io.github.isagroup.models.usagelimittypes.ResponseDriven;
import io.github.isagroup.models.usagelimittypes.TimeDriven;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UsageLimitParser {
    private UsageLimitParser() {
    }

    public static UsageLimit parseMapToUsageLimit(String limitName, Map<String, Object> limitMap, PricingManager pricingManager) {
        Set<String> featureKeys = pricingManager.getFeatures().keySet();
        try {
            switch (UsageLimitType.valueOf((String)limitMap.get("type"))) {
                case NON_RENEWABLE: {
                    return UsageLimitParser.parseMapToNonRenewable(limitName, limitMap, featureKeys);
                }
                case RENEWABLE: {
                    return UsageLimitParser.parseMapToRenewable(limitName, limitMap, featureKeys);
                }
                case RESPONSE_DRIVEN: {
                    return UsageLimitParser.parseMapToResponseDriven(limitName, limitMap, featureKeys);
                }
                case TIME_DRIVEN: {
                    return UsageLimitParser.parseMapToTimeDriven(limitName, limitMap, featureKeys);
                }
            }
            return null;
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new IllegalArgumentException("The usage limit " + limitName + " does not have a supported type (" + Arrays.toString((Object[])UsageLimitType.values()) + "). Current type value: " + (String)limitMap.get("type"));
        }
    }

    private static NonRenewable parseMapToNonRenewable(String limitName, Map<String, Object> map, Set<String> featureKeys) {
        NonRenewable nonRenewable = new NonRenewable();
        UsageLimitParser.loadBasicAttributes(nonRenewable, limitName, map, featureKeys);
        return nonRenewable;
    }

    private static Renewable parseMapToRenewable(String limitName, Map<String, Object> map, Set<String> featureKeys) {
        Renewable renewable = new Renewable();
        UsageLimitParser.loadBasicAttributes(renewable, limitName, map, featureKeys);
        return renewable;
    }

    private static ResponseDriven parseMapToResponseDriven(String limitName, Map<String, Object> map, Set<String> featureKeys) {
        ResponseDriven responseDriven = new ResponseDriven();
        UsageLimitParser.loadBasicAttributes(responseDriven, limitName, map, featureKeys);
        return responseDriven;
    }

    private static TimeDriven parseMapToTimeDriven(String limitName, Map<String, Object> map, Set<String> featureKeys) {
        TimeDriven timeDriven = new TimeDriven();
        UsageLimitParser.loadBasicAttributes(timeDriven, limitName, map, featureKeys);
        return timeDriven;
    }

    private static void loadBasicAttributes(UsageLimit limit, String limitName, Map<String, Object> map, Set<String> featureKeys) {
        if (limitName == null) {
            throw new PricingParsingException("An usageLimit name cannot be null");
        }
        limit.setName(limitName);
        limit.setDescription((String)map.get("description"));
        try {
            limit.setValueType(ValueType.valueOf((String)map.get("valueType")));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new InvalidValueTypeException("The feature " + limitName + " does not have a supported valueType (" + Arrays.toString((Object[])ValueType.values()) + "). Current valueType: " + (String)map.get("valueType"));
        }
        try {
            boolean isValueNull;
            Object defaultValue = map.get("defaultValue");
            boolean bl = isValueNull = defaultValue == null;
            if (isValueNull) {
                throw new InvalidDefaultValueException("The usageLimit " + limit.getName() + " does not have a valid defaultValue. Current valueType: " + limit.getValueType().toString() + "; Current defaultValue is null");
            }
            switch (limit.getValueType()) {
                case NUMERIC: {
                    limit.setDefaultValue(map.get("defaultValue"));
                    if (limit.getDefaultValue() instanceof Integer || limit.getDefaultValue() instanceof Double || limit.getDefaultValue() instanceof Long) break;
                    throw new InvalidDefaultValueException("The usageLimit " + limitName + " does not have a valid defaultValue. Current valueType:" + limit.getValueType().toString() + "; Current defaultValue: " + map.get("defaultValue").toString());
                }
                case BOOLEAN: {
                    limit.setDefaultValue((boolean)((Boolean)map.get("defaultValue")));
                    break;
                }
                case TEXT: {
                    limit.setDefaultValue((String)map.get("defaultValue"));
                }
            }
            if (limit.getDefaultValue() == null) {
                throw new InvalidDefaultValueException("The usageLimit " + limitName + " does not have a valid defaultValue. The actual value is null");
            }
        }
        catch (ClassCastException e) {
            throw new InvalidDefaultValueException("The feature " + limitName + " does not have a valid defaultValue. Current valueType:" + limit.getValueType().toString() + "; Current defaultValue: " + map.get("defaultValue").toString());
        }
        limit.setUnit((String)map.get("unit"));
        if (map.get("linkedFeatures") == null) {
            limit.setLinkedFeatures(null);
        } else {
            List linkedFeatures = (List)map.get("linkedFeatures");
            for (String linkedFeature : linkedFeatures) {
                if (featureKeys.contains(linkedFeature)) continue;
                throw new InvalidLinkedFeatureException("The usageLimit " + limitName + " is linked to a nonexistent feature. Current linkedFeature: " + linkedFeature);
            }
            limit.setLinkedFeatures(linkedFeatures);
        }
    }
}

