/*
 * Decompiled with CFR 0.152.
 */
package io.github.jaspeen.ulid;

import io.github.jaspeen.ulid.ULID;
import java.security.SecureRandom;
import java.util.Random;

public class MonotonicULID {
    private final Random random;
    private long lastTime = 0L;
    private final byte[] lastEntropy = new byte[10];
    public static MonotonicULID DEFAULT = new MonotonicULID(new SecureRandom());

    public MonotonicULID(Random random) {
        this.random = random;
    }

    public synchronized ULID next() {
        long now = System.currentTimeMillis();
        if (this.lastTime == now) {
            boolean carry = true;
            for (int i = 9; i >= 0; --i) {
                if (!carry) continue;
                byte work = this.lastEntropy[i];
                work = (byte)(work + 1);
                carry = this.lastEntropy[i] == -1 && carry;
                this.lastEntropy[i] = work;
            }
            if (carry) {
                throw new IllegalStateException("ULID entropy overflowed for same millisecond");
            }
        } else {
            this.lastTime = now;
            this.random.nextBytes(this.lastEntropy);
        }
        return ULID.generate(now, this.lastEntropy);
    }

    public static ULID random() {
        return DEFAULT.next();
    }
}

