/*
 * Decompiled with CFR 0.152.
 */
package io.github.jaspeen.ulid;

import java.io.Serializable;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public class ULID
implements Serializable,
Comparable<ULID> {
    public static final int STR_LENGTH = 26;
    public static final int BIN_LENGTH = 16;
    public static final int ENTROPY_LENGTH = 10;
    public static final long MIN_TIME = 0L;
    public static final long MAX_TIME = 0xFFFFFFFFFFFFL;
    private static final char[] C = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z'};
    private static final byte[] V = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 1, 18, 19, 1, 20, 21, 0, 22, 23, 24, 25, 26, -1, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 1, 18, 19, 1, 20, 21, 0, 22, 23, 24, 25, 26, -1, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1};
    private final long msb;
    private final long lsb;

    public ULID(long msb, long lsb) {
        this.msb = msb;
        this.lsb = lsb;
    }

    public long getMsb() {
        return this.msb;
    }

    public long getLsb() {
        return this.lsb;
    }

    public UUID toUUID() {
        return new UUID(this.msb, this.lsb);
    }

    public String toString() {
        char[] chars = new char[]{C[(byte)((this.msb >>> 56 & 0xFFL) >>> 5 & 0x1FL)], C[(byte)(this.msb >>> 56 & 0x1FL)], C[(byte)((this.msb >>> 48 & 0xFFL) >>> 3)], C[(byte)(((this.msb >>> 48 & 0xFFL) << 2 | (this.msb >>> 40 & 0xFFL) >>> 6) & 0x1FL)], C[(byte)((this.msb >>> 40 & 0xFFL) >>> 1 & 0x1FL)], C[(byte)(((this.msb >>> 40 & 0xFFL) << 4 | (this.msb >>> 32 & 0xFFL) >>> 4) & 0x1FL)], C[(byte)(((this.msb >>> 32 & 0xFFL) << 1 | (this.msb >>> 24 & 0xFFL) >>> 7) & 0x1FL)], C[(byte)((this.msb >>> 24 & 0xFFL) >>> 2 & 0x1FL)], C[(byte)(((this.msb >>> 24 & 0xFFL) << 3 | (this.msb >>> 16 & 0xFFL) >>> 5) & 0x1FL)], C[(byte)(this.msb >>> 16 & 0x1FL)], C[(byte)((this.msb >>> 8 & 0xFFL) >>> 3)], C[(byte)(((this.msb >>> 8 & 0xFFL) << 2 | (this.msb & 0xFFL) >>> 6) & 0x1FL)], C[(byte)((this.msb & 0xFFL) >>> 1 & 0x1FL)], C[(byte)(((this.msb & 0xFFL) << 4 | (this.lsb >>> 56 & 0xFFL) >>> 4) & 0x1FL)], C[(byte)(((this.lsb >>> 56 & 0xFFL) << 1 | (this.lsb >>> 48 & 0xFFL) >>> 7) & 0x1FL)], C[(byte)((this.lsb >>> 48 & 0xFFL) >>> 2 & 0x1FL)], C[(byte)(((this.lsb >>> 48 & 0xFFL) << 3 | (this.lsb >>> 40 & 0xFFL) >>> 5) & 0x1FL)], C[(byte)(this.lsb >>> 40 & 0x1FL)], C[(byte)((this.lsb >>> 32 & 0xFFL) >>> 3)], C[(byte)(((this.lsb >>> 32 & 0xFFL) << 2 | (this.lsb >>> 24 & 0xFFL) >>> 6) & 0x1FL)], C[(byte)((this.lsb >>> 24 & 0xFFL) >>> 1 & 0x1FL)], C[(byte)(((this.lsb >>> 24 & 0xFFL) << 4 | (this.lsb >>> 16 & 0xFFL) >>> 4) & 0x1FL)], C[(byte)(((this.lsb >>> 16 & 0xFFL) << 1 | (this.lsb >>> 8 & 0xFFL) >>> 7) & 0x1FL)], C[(byte)((this.lsb >>> 8 & 0xFFL) >>> 2 & 0x1FL)], C[(byte)(((this.lsb >>> 8 & 0xFFL) << 3 | (this.lsb & 0xFFL) >>> 5) & 0x1FL)], C[(byte)(this.lsb & 0x1FL)]};
        return new String(chars);
    }

    public int hashCode() {
        long hilo = this.msb ^ this.lsb;
        return (int)(hilo >> 32) ^ (int)hilo;
    }

    public boolean equals(Object obj) {
        if (null == obj || obj.getClass() != ULID.class) {
            return false;
        }
        ULID other = (ULID)obj;
        return this.msb == other.msb && this.lsb == other.lsb;
    }

    @Override
    public int compareTo(ULID val) {
        return this.msb < val.msb ? -1 : (this.msb > val.msb ? 1 : Long.compare(this.lsb, val.lsb));
    }

    public byte[] toBytes() {
        return new byte[]{(byte)(this.msb >> 56 & 0xFFL), (byte)(this.msb >> 48 & 0xFFL), (byte)(this.msb >> 40 & 0xFFL), (byte)(this.msb >> 32 & 0xFFL), (byte)(this.msb >> 24 & 0xFFL), (byte)(this.msb >> 16 & 0xFFL), (byte)(this.msb >> 8 & 0xFFL), (byte)(this.msb & 0xFFL), (byte)(this.lsb >> 56 & 0xFFL), (byte)(this.lsb >> 48 & 0xFFL), (byte)(this.lsb >> 40 & 0xFFL), (byte)(this.lsb >> 32 & 0xFFL), (byte)(this.lsb >> 24 & 0xFFL), (byte)(this.lsb >> 16 & 0xFFL), (byte)(this.lsb >> 8 & 0xFFL), (byte)(this.lsb & 0xFFL)};
    }

    public long getTimestamp() {
        return this.msb >>> 16;
    }

    public byte[] getEntropy() {
        return new byte[]{(byte)(this.msb >> 8 & 0xFFL), (byte)(this.msb & 0xFFL), (byte)(this.lsb >> 56 & 0xFFL), (byte)(this.lsb >> 48 & 0xFFL), (byte)(this.lsb >> 40 & 0xFFL), (byte)(this.lsb >> 32 & 0xFFL), (byte)(this.lsb >> 24 & 0xFFL), (byte)(this.lsb >> 16 & 0xFFL), (byte)(this.lsb >> 8 & 0xFFL), (byte)(this.lsb & 0xFFL)};
    }

    private static long bytesToLong(byte[] src, int offset) {
        return ((long)src[offset] & 0xFFL) << 56 | ((long)src[offset + 1] & 0xFFL) << 48 | ((long)src[offset + 2] & 0xFFL) << 40 | ((long)src[offset + 3] & 0xFFL) << 32 | ((long)src[offset + 4] & 0xFFL) << 24 | ((long)src[offset + 5] & 0xFFL) << 16 | ((long)src[offset + 6] & 0xFFL) << 8 | (long)src[offset + 7] & 0xFFL;
    }

    public static ULID random() {
        return ULID.random(ThreadLocalRandom.current());
    }

    public static ULID random(Random random) {
        byte[] entropy = new byte[10];
        random.nextBytes(entropy);
        return ULID.noCheckGenerate(System.currentTimeMillis(), entropy);
    }

    public static ULID generate(long time, byte[] entropy) {
        if (time < 0L || time > 0xFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid timestamp");
        }
        if (entropy == null || entropy.length != 10) {
            throw new IllegalArgumentException("Invalid entropy");
        }
        return ULID.noCheckGenerate(time, entropy);
    }

    private static ULID noCheckGenerate(long time, byte[] entropy) {
        long msb = time << 16 | (long)((entropy[0] & 0xFF) << 8) | (long)(entropy[1] & 0xFF);
        long lsb = ULID.bytesToLong(entropy, 2);
        return new ULID(msb, lsb);
    }

    private static byte valOrFail(char c) {
        byte res;
        if (c > 'z' || (res = V[c]) == -1) {
            throw new IllegalArgumentException("Invalid ULID char " + c);
        }
        return res;
    }

    public static ULID fromString(String val) {
        if (val.length() != 26) {
            throw new IllegalArgumentException("Invalid ULID string");
        }
        byte[] in = new byte[]{ULID.valOrFail(val.charAt(0)), ULID.valOrFail(val.charAt(1)), ULID.valOrFail(val.charAt(2)), ULID.valOrFail(val.charAt(3)), ULID.valOrFail(val.charAt(4)), ULID.valOrFail(val.charAt(5)), ULID.valOrFail(val.charAt(6)), ULID.valOrFail(val.charAt(7)), ULID.valOrFail(val.charAt(8)), ULID.valOrFail(val.charAt(9)), ULID.valOrFail(val.charAt(10)), ULID.valOrFail(val.charAt(11)), ULID.valOrFail(val.charAt(12)), ULID.valOrFail(val.charAt(13)), ULID.valOrFail(val.charAt(14)), ULID.valOrFail(val.charAt(15)), ULID.valOrFail(val.charAt(16)), ULID.valOrFail(val.charAt(17)), ULID.valOrFail(val.charAt(18)), ULID.valOrFail(val.charAt(19)), ULID.valOrFail(val.charAt(20)), ULID.valOrFail(val.charAt(21)), ULID.valOrFail(val.charAt(22)), ULID.valOrFail(val.charAt(23)), ULID.valOrFail(val.charAt(24)), ULID.valOrFail(val.charAt(25))};
        long msb = (long)(in[0] << 5 | in[1]) << 56 | (long)(in[2] << 3 | (in[3] & 0xFF) >>> 2) << 48 | (long)(in[3] << 6 | in[4] << 1 | (in[5] & 0xFF) >>> 4) << 40 | (long)(in[5] << 4 | (in[6] & 0xFF) >>> 1) << 32 | (long)(in[6] << 7 | in[7] << 2 | (in[8] & 0xFF) >>> 3) << 24 | (long)(in[8] << 5 | in[9]) << 16 | (long)(in[10] << 3 | (in[11] & 0xFF) >>> 2) << 8 | (long)(in[11] << 6 | in[12] << 1 | (in[13] & 0xFF) >>> 4);
        long lsb = (long)(in[13] << 4 | (in[14] & 0xFF) >>> 1) << 56 | (long)(in[14] << 7 | in[15] << 2 | (in[16] & 0xFF) >>> 3) << 48 | (long)(in[16] << 5 | in[17]) << 40 | (long)(in[18] << 3 | (in[19] & 0xFF) >>> 2) << 32 | (long)(in[19] << 6 | in[20] << 1 | (in[21] & 0xFF) >>> 4) << 24 | (long)(in[21] << 4 | (in[22] & 0xFF) >>> 1) << 16 | (long)(in[22] << 7 | in[23] << 2 | (in[24] & 0xFF) >>> 3) << 8 | (long)(in[24] << 5 | in[25]);
        return new ULID(msb, lsb);
    }

    public static ULID fromBytes(byte[] v) {
        if (v.length != 16) {
            throw new IllegalArgumentException("Invalid ULID bytes length: " + v.length);
        }
        long msb = ULID.bytesToLong(v, 0);
        long lsb = ULID.bytesToLong(v, 8);
        return new ULID(msb, lsb);
    }

    public static ULID fromUUID(UUID val) {
        return new ULID(val.getMostSignificantBits(), val.getLeastSignificantBits());
    }
}

