/*
 * Decompiled with CFR 0.152.
 */
package io.github.jaspeen.ulid.hibernate;

import io.github.jaspeen.ulid.ULID;
import io.github.jaspeen.ulid.hibernate.ULIDTypeDescriptor;
import java.util.Properties;
import java.util.UUID;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;

public class ULIDIdGenerator
implements IdentifierGenerator {
    private ULIDTypeDescriptor.ValueTransformer valueTransformer;

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        if (ULID.class.isAssignableFrom(type.getReturnedClass())) {
            this.valueTransformer = ULIDTypeDescriptor.PassThroughTransformer.INSTANCE;
        } else if (UUID.class.isAssignableFrom(type.getReturnedClass())) {
            this.valueTransformer = ULIDTypeDescriptor.ToUUIDTransformer.INSTANCE;
        } else if (String.class.isAssignableFrom(type.getReturnedClass())) {
            this.valueTransformer = ULIDTypeDescriptor.ToStringTransformer.INSTANCE;
        } else if (byte[].class.isAssignableFrom(type.getReturnedClass())) {
            this.valueTransformer = ULIDTypeDescriptor.ToBytesTransformer.INSTANCE;
        } else {
            throw new HibernateException("Unanticipated return type [" + type.getReturnedClass().getName() + "] for ULID conversion");
        }
    }

    public Object generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        Object id = session.getEntityPersister(null, object).getClassMetadata().getIdentifier(object, session);
        if (id != null) {
            return id;
        }
        ULID val = ULID.random();
        return this.valueTransformer.transform(val);
    }
}

