/*
 * Decompiled with CFR 0.152.
 */
package io.github.jaspeen.ulid.hibernate;

import io.github.jaspeen.ulid.ULID;
import java.io.Serializable;
import java.util.UUID;
import org.hibernate.internal.util.BytesHelper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class ULIDTypeDescriptor
extends AbstractJavaType<ULID> {
    public static final ULIDTypeDescriptor INSTANCE = new ULIDTypeDescriptor();

    public ULIDTypeDescriptor() {
        super(ULID.class);
    }

    public String toString(ULID value) {
        return ToStringTransformer.INSTANCE.transform(value);
    }

    public ULID fromString(String string) {
        return ToStringTransformer.INSTANCE.parse(string);
    }

    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators indicators) {
        return indicators.getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(12);
    }

    public <X> X unwrap(ULID value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (ULID.class.isAssignableFrom(type)) {
            return (X)PassThroughTransformer.INSTANCE.transform(value);
        }
        if (UUID.class.isAssignableFrom(type)) {
            return (X)ToUUIDTransformer.INSTANCE.transform(value);
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)ToStringTransformer.INSTANCE.transform(value);
        }
        if (byte[].class.isAssignableFrom(type)) {
            return (X)ToBytesTransformer.INSTANCE.transform(value);
        }
        throw this.unknownUnwrap(type);
    }

    public <X> ULID wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof ULID) {
            return PassThroughTransformer.INSTANCE.parse(value);
        }
        if (value instanceof UUID) {
            return ToUUIDTransformer.INSTANCE.parse(value);
        }
        if (value instanceof String) {
            return ToStringTransformer.INSTANCE.parse(value);
        }
        if (value instanceof byte[]) {
            return ToBytesTransformer.INSTANCE.parse(value);
        }
        throw this.unknownWrap(value.getClass());
    }

    public static class ToStringTransformer
    implements ValueTransformer {
        public static final ToStringTransformer INSTANCE = new ToStringTransformer();

        public String transform(ULID ulid) {
            return ulid.toString();
        }

        @Override
        public ULID parse(Object value) {
            return ULID.fromString((String)value);
        }
    }

    public static class PassThroughTransformer
    implements ValueTransformer {
        public static final PassThroughTransformer INSTANCE = new PassThroughTransformer();

        @Override
        public ULID transform(ULID ulid) {
            return ulid;
        }

        @Override
        public ULID parse(Object value) {
            return (ULID)value;
        }
    }

    public static class ToUUIDTransformer
    implements ValueTransformer {
        public static final ToUUIDTransformer INSTANCE = new ToUUIDTransformer();

        @Override
        public UUID transform(ULID ulid) {
            return ulid.toUUID();
        }

        @Override
        public ULID parse(Object value) {
            return ULID.fromUUID((UUID)value);
        }
    }

    public static class ToBytesTransformer
    implements ValueTransformer {
        public static final ToBytesTransformer INSTANCE = new ToBytesTransformer();

        public byte[] transform(ULID ulid) {
            byte[] bytes = new byte[16];
            BytesHelper.fromLong((long)ulid.getMsb(), (byte[])bytes, (int)0);
            BytesHelper.fromLong((long)ulid.getLsb(), (byte[])bytes, (int)8);
            return bytes;
        }

        @Override
        public ULID parse(Object value) {
            byte[] bytea = (byte[])value;
            return new ULID(BytesHelper.asLong((byte[])bytea, (int)0), BytesHelper.asLong((byte[])bytea, (int)8));
        }
    }

    public static interface ValueTransformer {
        public Serializable transform(ULID var1);

        public ULID parse(Object var1);
    }
}

