/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.util;

import io.jbock.util.Left;
import io.jbock.util.Right;
import io.jbock.util.ValidatingCollector;
import io.jbock.util.ValidatingCollectorAll;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;

public abstract class Either<L, R> {
    Either() {
    }

    public static <L, R> Either<L, R> left(L value) {
        return new Left(value);
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Right(value);
    }

    public static <L, R> Collector<Either<? extends L, ? extends R>, ?, Either<L, List<R>>> toValidList() {
        return new ValidatingCollector();
    }

    public static <L, R> Collector<Either<? extends L, ? extends R>, ?, Either<List<L>, List<R>>> toValidListAll() {
        return new ValidatingCollectorAll();
    }

    public static <T> Optional<List<T>> optionalList(List<? extends T> values) {
        if (values.isEmpty()) {
            return Optional.empty();
        }
        List<T> result = values;
        return Optional.of(result);
    }

    public abstract <R2> Either<L, R2> map(Function<? super R, ? extends R2> var1);

    public abstract <R2> Either<L, R2> flatMap(Function<? super R, ? extends Either<? extends L, ? extends R2>> var1);

    public abstract Either<L, R> filter(Function<? super R, Optional<? extends L>> var1);

    public abstract <L2> Either<L2, R> mapLeft(Function<? super L, ? extends L2> var1);

    public abstract <L2> Either<L2, R> flatMapLeft(Function<? super L, ? extends Either<? extends L2, ? extends R>> var1);

    public abstract Either<L, R> filterLeft(Function<? super L, Optional<? extends R>> var1);

    public abstract <U> U fold(Function<? super L, ? extends U> var1, Function<? super R, ? extends U> var2);

    public abstract void ifLeftOrElse(Consumer<? super L> var1, Consumer<? super R> var2);

    public abstract <X extends Throwable> R orElseThrow(Function<? super L, ? extends X> var1) throws X;

    public abstract boolean isLeft();

    public final boolean isRight() {
        return !this.isLeft();
    }

    public abstract Optional<L> getLeft();

    public abstract Optional<R> getRight();

    public abstract String toString();
}

