/*
 * Decompiled with CFR 0.152.
 */
package io.github.jdiscordbots.command_framework;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import io.github.jdiscordbots.command_framework.CommandHandler;
import io.github.jdiscordbots.command_framework.CommandListener;
import io.github.jdiscordbots.command_framework.SlashCommandBuilder;
import io.github.jdiscordbots.command_framework.command.Command;
import io.github.jdiscordbots.command_framework.command.CommandEvent;
import io.github.jdiscordbots.command_framework.command.ICommand;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.requests.RestAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandFramework {
    private static final Logger LOG = LoggerFactory.getLogger(CommandFramework.class);
    private final AtomicReference<Consumer<CommandEvent>> unknownCommandConsumer = new AtomicReference();
    private final AtomicReference<Consumer<ButtonInteractionEvent>> unknownButtonConsumer = new AtomicReference();
    private final AtomicReference<String> prefix = new AtomicReference<String>("!");
    private final Set<String> owners = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile boolean mentionPrefix = true;
    private volatile boolean unknownCommand = true;
    private volatile boolean slashCommandsPerGuild = false;
    private volatile boolean removeUnknownSlashCommands = true;
    private CommandHandler handler = new CommandHandler();

    public CommandFramework() {
        this(CommandFramework.getCallerPackageName());
        if (this.getClass() != CommandFramework.class) {
            throw new IllegalStateException("This constructor may not be called by subclasses!");
        }
    }

    protected static final String getCallerPackageName() {
        try {
            StackTraceElement trace = new Throwable().getStackTrace()[2];
            String clName = trace.getClassName();
            return Thread.currentThread().getContextClassLoader().loadClass(clName).getPackage().getName();
        }
        catch (ClassNotFoundException ignored) {
            throw new IllegalStateException("caller class not available");
        }
    }

    public CommandFramework(String commandsRootPackage) {
        try (ScanResult scanResult = new ClassGraph().acceptPackages(new String[]{commandsRootPackage}).enableAnnotationInfo().scan();){
            this.addCommands(scanResult);
        }
    }

    private void addCommands(ScanResult scanResult) {
        CommandFramework.addAction(scanResult, (cmdAsAnnotation, annotatedAsObject) -> {
            Command cmdAsBotCommand = (Command)cmdAsAnnotation;
            ICommand cmd = (ICommand)annotatedAsObject;
            for (String alias : cmdAsBotCommand.value()) {
                this.handler.addCommand(alias.toLowerCase(), cmd);
            }
        });
    }

    private static void addAction(ScanResult scanResult, BiConsumer<Annotation, Object> function) {
        for (ClassInfo cInfo : scanResult.getClassesWithAnnotation(Command.class.getCanonicalName())) {
            try {
                Class cl = cInfo.loadClass();
                Object annotatedAsObject = cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Command cmdAsAnnotation = cl.getAnnotation(Command.class);
                function.accept(cmdAsAnnotation, annotatedAsObject);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("An exception occurred trying to create and register an instance of the class {}.", (Object)cInfo.getName(), (Object)e);
            }
        }
    }

    public final CommandFramework setPrefix(String prefix) {
        this.prefix.set(prefix);
        return this;
    }

    public final String getPrefix() {
        return this.prefix.get();
    }

    public final CommandFramework setOwners(String ... owners) {
        this.setOwners(Arrays.asList(owners));
        return this;
    }

    public final Set<String> getOwners() {
        return Collections.unmodifiableSet(this.owners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CommandFramework setOwners(Collection<String> owners) {
        Set<String> set = this.owners;
        synchronized (set) {
            this.owners.clear();
            this.owners.addAll(owners);
        }
        return this;
    }

    public final CommandFramework setMentionPrefix(boolean mentionPrefix) {
        this.mentionPrefix = mentionPrefix;
        return this;
    }

    public final boolean isMentionPrefix() {
        return this.mentionPrefix;
    }

    public final CommandFramework setUnknownCommand(boolean unknownCommand) {
        this.unknownCommand = unknownCommand;
        return this;
    }

    protected Consumer<CommandEvent> getUnknownCommandConsumer() {
        return this.unknownCommandConsumer.get();
    }

    public final CommandFramework setUnknownCommandAction(Consumer<CommandEvent> unknownCommandConsumer) {
        this.unknownCommandConsumer.set(unknownCommandConsumer);
        return this.setUnknownCommand(true);
    }

    public final boolean isUnknownCommand() {
        return this.unknownCommand;
    }

    public final CommandFramework setSlashCommandsPerGuild(boolean slashCommandsPerGuild) {
        this.slashCommandsPerGuild = slashCommandsPerGuild;
        return this;
    }

    public final boolean isSlashCommandsPerGuild() {
        return this.slashCommandsPerGuild;
    }

    public final void setRemoveUnknownSlashCommands(boolean removeUnknownSlashCommands) {
        this.removeUnknownSlashCommands = removeUnknownSlashCommands;
    }

    public final boolean isRemoveUnknownSlashCommands() {
        return this.removeUnknownSlashCommands;
    }

    public ListenerAdapter build() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Listening to following commands ({}):\n{}", (Object)this.handler.getCommands().size(), (Object)String.join((CharSequence)", ", this.handler.getCommands().keySet()));
        }
        return new CommandListener(this);
    }

    protected Consumer<ButtonInteractionEvent> getUnknownButtonAction() {
        return this.unknownButtonConsumer.get();
    }

    public final CommandFramework setUnknownButtonAction(Consumer<ButtonInteractionEvent> unknownButtonConsumer) {
        this.unknownButtonConsumer.set(unknownButtonConsumer);
        return this;
    }

    public final Map<String, ICommand> getCommands() {
        return this.handler.getCommands();
    }

    public final Consumer<JDA> addCommand(String name, ICommand cmd) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(cmd);
        name = name.toLowerCase();
        this.handler.addCommand(name, cmd);
        CommandData cmdData = SlashCommandBuilder.buildSlashCommand(name, cmd);
        return jda -> jda.upsertCommand(cmdData).queue(actualCommand -> {
            for (Guild guild : jda.getGuilds()) {
                guild.updateCommandPrivilegesById(actualCommand.getId(), cmd.getPrivileges(guild)).queue();
            }
        });
    }

    public final Consumer<JDA> removeCommand(String name) {
        Objects.requireNonNull(name);
        String actualName = name.toLowerCase();
        this.handler.removeCommand(actualName);
        return jda -> Stream.concat(Stream.of(jda.retrieveCommands()), jda.getGuilds().stream().map(Guild::retrieveCommands)).forEach(cmds -> this.removeSlashCommand((JDA)jda, actualName, (RestAction<List<net.dv8tion.jda.api.interactions.commands.Command>>)cmds));
    }

    private void removeSlashCommand(JDA jda, String name, RestAction<List<net.dv8tion.jda.api.interactions.commands.Command>> commands) {
        commands.queue(cmds -> cmds.stream().filter(cmd -> name.equals(cmd.getName())).forEach(cmd -> jda.deleteCommandById(cmd.getId()).queue()));
    }

    CommandHandler getCommandHandler() {
        return this.handler;
    }
}

