/*
 * Decompiled with CFR 0.152.
 */
package io.github.jdiscordbots.command_framework;

import io.github.jdiscordbots.command_framework.CommandContainer;
import io.github.jdiscordbots.command_framework.CommandFramework;
import io.github.jdiscordbots.command_framework.CommandHandler;
import io.github.jdiscordbots.command_framework.CommandParser;
import io.github.jdiscordbots.command_framework.SlashCommandBuilder;
import io.github.jdiscordbots.command_framework.command.ICommand;
import io.github.jdiscordbots.command_framework.command.slash.SlashCommandFrameworkEvent;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.events.ReadyEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.interactions.commands.privileges.CommandPrivilege;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.CommandListUpdateAction;

final class CommandListener
extends ListenerAdapter {
    private final CommandFramework framework;
    private final CommandHandler handler;

    public CommandListener(CommandFramework framework) {
        this.framework = framework;
        this.handler = framework.getCommandHandler();
    }

    public void onReady(ReadyEvent event) {
        this.initializeSlashCommands(event.getJDA());
    }

    private void initializeSlashCommands(JDA jda) {
        Collection<CommandData> slashCommands = this.getSlashCommands();
        this.initializeSlashCommands(jda, slashCommands);
    }

    private void initializeSlashCommands(JDA jda, Collection<CommandData> slashCommands) {
        if (this.framework.isSlashCommandsPerGuild()) {
            for (Guild guild : jda.getGuilds()) {
                this.initializeSlashCommands(slashCommands, () -> ((Guild)guild).updateCommands(), () -> ((Guild)guild).retrieveCommands()).queue(cmds -> this.setupSlashCommandPermissions(guild, (Map<String, String>)cmds));
            }
        } else {
            this.initializeSlashCommands(slashCommands, () -> ((JDA)jda).updateCommands(), () -> ((JDA)jda).retrieveCommands()).queue(cmds -> {
                for (Guild guild : jda.getGuilds()) {
                    this.setupSlashCommandPermissions(guild, (Map<String, String>)cmds);
                }
            });
        }
    }

    private void setupSlashCommandPermissions(Guild g, Map<String, String> commandIds) {
        Map<String, Collection> privileges = this.framework.getCommands().entrySet().stream().map(cmd -> new AbstractMap.SimpleEntry<String, Collection<CommandPrivilege>>((String)commandIds.get(cmd.getKey()), this.addOwnerPrivileges(((ICommand)cmd.getValue()).getPrivileges(g)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        g.updateCommandPrivileges(privileges).queue();
    }

    private Collection<CommandPrivilege> addOwnerPrivileges(Collection<? extends CommandPrivilege> privileges) {
        return Stream.concat(this.framework.getOwners().stream().map(CommandPrivilege::enableUser), privileges.stream()).collect(Collectors.toSet());
    }

    private RestAction<Map<String, String>> initializeSlashCommands(Collection<CommandData> slashCommands, Supplier<CommandListUpdateAction> commandUpdater, Supplier<RestAction<List<Command>>> commandRetriever) {
        CommandListUpdateAction commandsAction = commandUpdater.get().addCommands(slashCommands);
        if (this.framework.isRemoveUnknownSlashCommands()) {
            commandRetriever.get().queue(commands -> commands.stream().filter(cmd -> slashCommands.stream().noneMatch(sCmd -> sCmd.getName().equals(cmd.getName()))).forEach(cmd -> cmd.delete().queue()));
        }
        return commandsAction.map(commands -> commands.stream().collect(Collectors.toMap(Command::getName, ISnowflake::getId)));
    }

    private Collection<CommandData> getSlashCommands() {
        ArrayList<CommandData> slashCommands = new ArrayList<CommandData>();
        this.framework.getCommands().forEach((name, cmd) -> slashCommands.add(SlashCommandBuilder.buildSlashCommand(name, cmd)));
        return slashCommands;
    }

    public void onMessageReceived(MessageReceivedEvent event) {
        boolean containsMention;
        Message message = event.getMessage();
        String contentRaw = message.getContentRaw().trim();
        String selfUserId = message.getJDA().getSelfUser().getId();
        boolean bl = containsMention = contentRaw.startsWith("<!@" + selfUserId + "> ") || contentRaw.startsWith("<@" + selfUserId + "> ");
        if (message.getAuthor().isBot()) {
            return;
        }
        if (this.framework.isMentionPrefix() && containsMention) {
            this.handler.handle(CommandParser.parse(this.framework, event, CommandParser.SPACE_PATTERN.split(contentRaw)[0] + " "));
            return;
        }
        if (message.getContentDisplay().startsWith(this.framework.getPrefix())) {
            this.handler.handle(CommandParser.parse(this.framework, event, this.framework.getPrefix()));
        }
    }

    public void onSlashCommandInteraction(SlashCommandInteractionEvent event) {
        event.deferReply().queue();
        SlashCommandFrameworkEvent frameworkEvent = new SlashCommandFrameworkEvent(this.framework, event);
        this.handler.handle(new CommandContainer(event.getName(), frameworkEvent));
    }

    public void onButtonInteraction(ButtonInteractionEvent event) {
        this.handler.handleButtonClick(this.framework, event);
    }
}

