/*
 * Decompiled with CFR 0.152.
 */
package io.github.jdiscordbots.command_framework;

import io.github.jdiscordbots.command_framework.CommandContainer;
import io.github.jdiscordbots.command_framework.CommandFramework;
import io.github.jdiscordbots.command_framework.command.text.MessageArgument;
import io.github.jdiscordbots.command_framework.command.text.MessageCommandEvent;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;

final class CommandParser {
    static final Pattern SPACE_PATTERN = Pattern.compile("\\s+");

    private CommandParser() {
    }

    static CommandContainer parse(CommandFramework framework, MessageReceivedEvent event, String prefix) {
        String raw = event.getMessage().getContentRaw();
        String beheaded = raw.replaceFirst(Pattern.quote(prefix), "");
        String[] splitBeheaded = SPACE_PATTERN.split(beheaded.trim());
        String invoke = splitBeheaded[0];
        ArrayList<String> split = new ArrayList<String>();
        boolean inQuote = false;
        for (int i = 1; i < splitBeheaded.length; ++i) {
            String s = splitBeheaded[i];
            if (inQuote) {
                if (s.endsWith("\"")) {
                    inQuote = false;
                    s = s.substring(0, s.length() - 1);
                }
                split.add((String)split.remove(split.size() - 1) + " " + s);
                continue;
            }
            if (s.startsWith("\"") && !s.endsWith("\"")) {
                inQuote = true;
                s = s.substring(1);
            }
            split.add(s);
        }
        MessageCommandEvent commandEvent = new MessageCommandEvent(framework, event, split.stream().map(str -> new MessageArgument(event.getMessage(), (String)str)).collect(Collectors.toList()));
        return new CommandContainer(invoke, commandEvent);
    }
}

