/*
 * Decompiled with CFR 0.152.
 */
package io.github.jdiscordbots.command_framework;

import io.github.jdiscordbots.command_framework.command.ArgumentTemplate;
import io.github.jdiscordbots.command_framework.command.ICommand;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandGroupData;

final class SlashCommandBuilder {
    private final SlashCommandData commandData;
    private SubcommandGroupData group;
    private SubcommandData subcommand;

    public SlashCommandBuilder(SlashCommandData commandData) {
        this.commandData = commandData;
    }

    public static CommandData buildSlashCommand(String name, ICommand cmd) {
        SlashCommandData commandData = Commands.slash((String)name, (String)cmd.help());
        SlashCommandBuilder subCommandInfo = new SlashCommandBuilder(commandData);
        for (ArgumentTemplate arg : cmd.getExpectedArguments()) {
            subCommandInfo.setupSlashArgument(arg);
        }
        commandData.setDefaultEnabled(cmd.isAvailableToEveryone());
        return commandData;
    }

    private void setupSlashArgument(ArgumentTemplate arg) {
        switch (arg.getType()) {
            case SUB_COMMAND: {
                this.addSubCommand(arg);
                break;
            }
            case SUB_COMMAND_GROUP: {
                this.addSubCommandGroup(arg);
                break;
            }
            default: {
                this.addNormalArgument(arg);
            }
        }
    }

    private void addSubCommand(ArgumentTemplate arg) {
        this.subcommand = new SubcommandData(arg.getName(), arg.getDescription());
        if (this.group == null) {
            this.commandData.addSubcommands(new SubcommandData[]{this.subcommand});
        } else {
            this.group.addSubcommands(new SubcommandData[]{this.subcommand});
        }
    }

    private void addSubCommandGroup(ArgumentTemplate arg) {
        this.group = new SubcommandGroupData(arg.getName(), arg.getDescription());
        this.commandData.addSubcommandGroups(new SubcommandGroupData[]{this.group});
    }

    private void addNormalArgument(ArgumentTemplate arg) {
        OptionData option = new OptionData(arg.getType(), arg.getName(), arg.getDescription());
        option.setRequired(arg.isRequired());
        if (arg.hasChoices()) {
            for (String choice : arg.getChoices()) {
                if (arg.getType() == OptionType.INTEGER) {
                    option.addChoice(choice, (long)Integer.parseInt(choice));
                    continue;
                }
                option.addChoice(choice, choice);
            }
        }
        if (this.subcommand == null) {
            this.commandData.addOptions(new OptionData[]{option});
        } else {
            this.subcommand.addOptions(new OptionData[]{option});
        }
    }
}

