/*
 * Decompiled with CFR 0.152.
 */
package io.github.jdiscordbots.command_framework.command;

import java.util.Arrays;
import java.util.Objects;
import net.dv8tion.jda.api.interactions.commands.OptionType;

public final class ArgumentTemplate {
    private final OptionType type;
    private final String name;
    private final String description;
    private final boolean required;
    private final String[] choices;

    private ArgumentTemplate(OptionType type, String name, String description, boolean required, String[] choices) {
        Objects.requireNonNull(type);
        if (type == OptionType.UNKNOWN) {
            throw new IllegalArgumentException("OptionType.UNKNOWN not supported");
        }
        Objects.requireNonNull(name);
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Argument name is empty");
        }
        Objects.requireNonNull(description);
        if (description.isEmpty()) {
            throw new IllegalArgumentException("Argument description is empty");
        }
        if (choices != null && !type.canSupportChoices()) {
            throw new IllegalArgumentException("Tried to use choices on a type (" + type + ") that does not support choices");
        }
        this.type = type;
        this.name = name;
        this.description = description;
        this.required = required;
        this.choices = choices;
    }

    public ArgumentTemplate(OptionType type, String name, String description, boolean required) {
        this(type, name, description, required, null);
    }

    public ArgumentTemplate(String name, String description, boolean required, String ... choices) {
        this(OptionType.STRING, name, description, required, choices == null || choices.length == 0 ? null : Arrays.copyOf(choices, choices.length));
    }

    public ArgumentTemplate(String name, String description, boolean required, int ... choices) {
        this(OptionType.INTEGER, name, description, required, choices == null || choices.length == 0 ? null : (String[])Arrays.stream(choices).mapToObj(String::valueOf).toArray(String[]::new));
    }

    public OptionType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String[] getChoices() {
        return this.choices == null ? null : Arrays.copyOf(this.choices, this.choices.length);
    }

    public boolean hasChoices() {
        return this.choices != null;
    }
}

