/*
 * Decompiled with CFR 0.152.
 */
package io.github.jdiscordbots.command_framework.command.slash;

import io.github.jdiscordbots.command_framework.CommandFramework;
import io.github.jdiscordbots.command_framework.command.Argument;
import io.github.jdiscordbots.command_framework.command.ArgumentTemplate;
import io.github.jdiscordbots.command_framework.command.CommandEvent;
import io.github.jdiscordbots.command_framework.command.slash.SlashArgument;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.MessageType;
import net.dv8tion.jda.api.entities.PrivateChannel;
import net.dv8tion.jda.api.entities.SelfUser;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.entities.SystemMessage;

public final class SlashCommandFrameworkEvent
implements CommandEvent {
    private final CommandFramework framework;
    private final SlashCommandInteractionEvent event;
    private final List<Argument> args;
    private AtomicReference<Message> firstMessage = new AtomicReference();

    public SlashCommandFrameworkEvent(CommandFramework framework, SlashCommandInteractionEvent event) {
        this.framework = framework;
        this.event = event;
        this.args = null;
    }

    public SlashCommandFrameworkEvent(CommandFramework framework, SlashCommandInteractionEvent event, Collection<ArgumentTemplate> expectedArgs) {
        this.framework = framework;
        this.event = event;
        this.args = Collections.unmodifiableList(this.loadArgs(expectedArgs));
    }

    private List<Argument> loadArgs(Collection<ArgumentTemplate> expectedArgs) {
        return Stream.concat(this.createSubcommandDataStream(), this.createActualArgumentsStream(expectedArgs)).collect(Collectors.toList());
    }

    private Stream<Argument> createSubcommandDataStream() {
        return Stream.of(this.event.getSubcommandGroup(), this.event.getSubcommandName()).filter(Objects::nonNull).map(SlashCommandFrameworkEvent::createOptionDataFromString);
    }

    private Stream<Argument> createActualArgumentsStream(Collection<ArgumentTemplate> expectedArgs) {
        return expectedArgs.stream().map(ArgumentTemplate::getName).map(arg_0 -> ((SlashCommandInteractionEvent)this.event).getOption(arg_0)).filter(Objects::nonNull).map(SlashArgument::new);
    }

    private static Argument createOptionDataFromString(String in) {
        return new SlashArgument(new OptionMapping(new DataObject(SlashCommandFrameworkEvent.creationOptionDataMap(in)){}, null));
    }

    private static Map<String, Object> creationOptionDataMap(String in) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("value", in);
        ret.put("name", "subcommand");
        return ret;
    }

    @Override
    public CommandFramework getFramework() {
        return this.framework;
    }

    @Override
    public List<Argument> getArgs() {
        return this.args;
    }

    @Override
    public Guild getGuild() {
        return this.event.getGuild();
    }

    @Override
    public JDA getJDA() {
        return this.event.getJDA();
    }

    @Override
    public User getAuthor() {
        return this.event.getUser();
    }

    @Override
    public Member getMember() {
        return this.event.getMember();
    }

    @Override
    public MessageChannel getChannel() {
        return this.event.getMessageChannel();
    }

    @Override
    public SelfUser getSelfUser() {
        return this.getJDA().getSelfUser();
    }

    @Override
    public Member getSelfMember() {
        return this.event.getGuild().getSelfMember();
    }

    @Override
    public String getId() {
        return this.event.getInteraction().getId();
    }

    @Override
    public PrivateChannel getPrivateChannel() {
        return this.event.getPrivateChannel();
    }

    @Override
    public Message getMessage() {
        Message msg = this.firstMessage.get();
        if (msg == null) {
            return new SystemMessage(this.getIdLong(), this.getChannel(), MessageType.SLASH_COMMAND, null, true, false, null, null, false, false, this.getArgs().stream().map(Argument::getAsString).collect(Collectors.joining(" ")), "", this.getAuthor(), this.getMember(), null, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), 0);
        }
        return msg;
    }

    @Override
    public long getIdLong() {
        return this.event.getInteraction().getIdLong();
    }

    @Override
    public RestAction<Message> reply(String message) {
        return this.event.getHook().sendMessage(message).map(this::saveMessageIfFirst);
    }

    @Override
    public RestAction<Message> reply(Message message) {
        return this.event.getHook().sendMessage(message).map(this::saveMessageIfFirst);
    }

    @Override
    public RestAction<Message> reply(MessageEmbed message) {
        return this.event.getHook().sendMessageEmbeds(message, new MessageEmbed[0]).map(this::saveMessageIfFirst);
    }

    private Message saveMessageIfFirst(Message msg) {
        this.firstMessage.compareAndSet(null, msg);
        return msg;
    }

    @Override
    public RestAction<Void> deleteOriginalMessage() {
        return this.event.getHook().deleteOriginal();
    }

    public SlashCommandInteractionEvent getEvent() {
        return this.event;
    }
}

