/*
 * Decompiled with CFR 0.152.
 */
package io.github.jdiscordbots.command_framework.command.text;

import io.github.jdiscordbots.command_framework.command.Argument;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.interactions.commands.OptionType;

public final class MessageArgument
implements Argument {
    private static final Pattern USER_FORMAT = Pattern.compile("\\<@!?(\\d+)\\>");
    private static final Pattern ROLE_FORMAT = Pattern.compile("\\<@&(\\d+)\\>");
    private static final Pattern CHANNEL_FORMAT = Pattern.compile("\\<#(\\d+)\\>");
    private final Message msg;
    private final String text;

    public MessageArgument(Message msg, String text) {
        this.msg = msg;
        this.text = text;
    }

    @Override
    public String getAsString() {
        return this.text;
    }

    @Override
    public Role getAsRole() {
        this.requireInGuild();
        return this.getAsMentionedEntityOrThrowIfNotExist(ROLE_FORMAT, arg_0 -> ((Guild)this.msg.getGuild()).getRoleById(arg_0), () -> new IllegalStateException("Argument cannot be converted to Role"));
    }

    @Override
    public boolean getAsBoolean() {
        return Boolean.parseBoolean(this.text);
    }

    @Override
    public OptionType getType() {
        return OptionType.STRING;
    }

    @Override
    public long getAsLong() {
        return Long.parseLong(this.text);
    }

    @Override
    public Member getAsMember() {
        this.requireInGuild();
        return this.getAsMentionedEntityOrThrowIfNotExist(USER_FORMAT, arg_0 -> ((Guild)this.msg.getGuild()).getMemberById(arg_0), () -> new IllegalStateException("Argument cannot be converted to Member"));
    }

    @Override
    public User getAsUser() {
        return this.getAsMentionedEntityOrThrowIfNotExist(USER_FORMAT, arg_0 -> ((JDA)this.msg.getJDA()).getUserById(arg_0), () -> new IllegalStateException("Argument cannot be converted to User"));
    }

    @Override
    public GuildChannel getAsGuildChannel() {
        this.requireInGuild();
        return this.getAsMentionedEntityOrThrowIfNotExist(CHANNEL_FORMAT, arg_0 -> ((Guild)this.msg.getGuild()).getGuildChannelById(arg_0), () -> new IllegalStateException("Argument cannot be converted to guild channel"));
    }

    @Override
    public MessageChannel getAsMessageChannel() {
        return this.getAsMentionedEntityOrThrowIfNotExist(CHANNEL_FORMAT, id -> this.getMessageChannelFromId(this.msg.getJDA(), (String)id), () -> new IllegalStateException("Argument cannot be converted to message channel"));
    }

    private MessageChannel getMessageChannelFromId(JDA jda, String id) {
        MessageChannel ret = null;
        GuildChannel gc = jda.getGuildChannelById(id);
        if (gc instanceof MessageChannel) {
            ret = (MessageChannel)gc;
        }
        if (ret == null) {
            ret = jda.getPrivateChannelById(id);
        }
        return ret;
    }

    private void requireInGuild() {
        if (!this.msg.isFromGuild()) {
            throw new IllegalStateException("Cannot get member if user is not in guild");
        }
    }

    private <T, E extends Exception> T getAsMentionedEntityOrThrowIfNotExist(Pattern pattern, Function<String, T> converter, Supplier<E> toThrow) throws E {
        T entity = this.getAsMentionedEntity(pattern, converter);
        if (entity == null) {
            throw (Exception)toThrow.get();
        }
        return entity;
    }

    private <T> T getAsMentionedEntity(Pattern pattern, Function<String, T> converter) {
        Matcher matcher = pattern.matcher(this.text);
        if (matcher.matches()) {
            return converter.apply(matcher.group(1));
        }
        return converter.apply(this.text);
    }

    @Override
    public ChannelType getChannelType() {
        return this.msg.getChannelType();
    }
}

