/*
 * Decompiled with CFR 0.152.
 */
package io.github.jdiscordbots.command_framework;

import io.github.jdiscordbots.command_framework.CommandContainer;
import io.github.jdiscordbots.command_framework.CommandFramework;
import io.github.jdiscordbots.command_framework.CommandParser;
import io.github.jdiscordbots.command_framework.command.CommandEvent;
import io.github.jdiscordbots.command_framework.command.ICommand;
import io.github.jdiscordbots.command_framework.command.slash.SlashCommandFrameworkEvent;
import java.awt.Color;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CommandHandler {
    private final Map<String, ICommand> commands = new ConcurrentHashMap<String, ICommand>();
    private static final Logger LOG = LoggerFactory.getLogger(CommandHandler.class);

    CommandHandler() {
    }

    Map<String, ICommand> getCommands() {
        return Collections.unmodifiableMap(this.commands);
    }

    void addCommand(String name, ICommand command) {
        this.commands.put(name, command);
    }

    void removeCommand(String name) {
        this.commands.remove(name);
    }

    public void handle(CommandContainer commandContainer) {
        CommandEvent event = commandContainer.event;
        String cmdIdentifier = commandContainer.invoke.toLowerCase();
        if (this.commands.containsKey(cmdIdentifier)) {
            ICommand command = this.commands.get(cmdIdentifier);
            boolean canExecute = true;
            if (event instanceof SlashCommandFrameworkEvent) {
                event = new SlashCommandFrameworkEvent(event.getFramework(), ((SlashCommandFrameworkEvent)event).getEvent(), command.getExpectedArguments());
            }
            if ((canExecute &= command.allowExecute(event)) || event.getFramework().getOwners().contains(event.getAuthor().getId())) {
                try {
                    command.action(event);
                }
                catch (RuntimeException e) {
                    LOG.error("The command {} was executed but an error occurred.", (Object)commandContainer.invoke, (Object)e);
                    event.reply("Error:\n```" + e.getMessage() + "\n```");
                }
            } else {
                event.reply("You're not allowed to use this command!").queue();
            }
        } else if (event.getFramework().isUnknownCommand()) {
            Consumer<CommandEvent> unknownCommandConsumer = event.getFramework().getUnknownCommandConsumer();
            if (unknownCommandConsumer == null) {
                EmbedBuilder eb = new EmbedBuilder().setColor(Color.red).setTitle("Unknown command").setDescription((CharSequence)("See `" + event.getFramework().getPrefix() + "help` for more information!"));
                event.reply(eb.build());
            } else {
                unknownCommandConsumer.accept(event);
            }
        }
    }

    public void handleButtonClick(CommandFramework framework, ButtonInteractionEvent event) {
        String btnId = event.getButton().getId();
        if (btnId != null) {
            String btnIdPrefix = CommandParser.SPACE_PATTERN.split(btnId)[0];
            ICommand cmd = this.commands.get(btnIdPrefix);
            if (cmd != null) {
                cmd.onButtonClick(event);
            } else {
                Consumer<ButtonInteractionEvent> unknownButtonConsumer = framework.getUnknownButtonAction();
                if (unknownButtonConsumer == null) {
                    event.deferEdit().queue();
                } else {
                    unknownButtonConsumer.accept(event);
                }
            }
        }
    }
}

