/*
 * Decompiled with CFR 0.152.
 */
package io.github.jdiscordbots.command_framework.command;

import io.github.jdiscordbots.command_framework.command.ArgumentTemplate;
import io.github.jdiscordbots.command_framework.command.CommandEvent;
import io.github.jdiscordbots.command_framework.command.slash.SlashCommandFrameworkEvent;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import org.jetbrains.annotations.Contract;

public interface ICommand {
    public void action(CommandEvent var1);

    default public void onButtonClick(ButtonInteractionEvent event) {
        event.deferEdit().queue();
    }

    @Contract(pure=true)
    default public boolean allowExecute(CommandEvent event) {
        if (this.isAvailableToEveryone()) {
            return true;
        }
        if (event instanceof SlashCommandFrameworkEvent) {
            return true;
        }
        for (Permission perm : this.getRequiredPermissions()) {
            if (!event.getMember().hasPermission(new Permission[]{perm})) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    default public Set<Permission> getRequiredPermissions() {
        return this.isAvailableToEveryone() ? null : Collections.emptySet();
    }

    @Contract(pure=true)
    default public boolean isAvailableToEveryone() {
        return true;
    }

    @Contract(pure=true)
    public String help();

    @Contract(pure=true)
    public List<ArgumentTemplate> getExpectedArguments();
}

