/*
 * Decompiled with CFR 0.152.
 */
package io.github.jdiscordbots.command_framework.command.text;

import io.github.jdiscordbots.command_framework.CommandFramework;
import io.github.jdiscordbots.command_framework.command.Argument;
import io.github.jdiscordbots.command_framework.command.CommandEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.SelfUser;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.concrete.PrivateChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;

public final class MessageCommandEvent
implements CommandEvent {
    private final CommandFramework framework;
    private final MessageReceivedEvent event;
    private final List<Argument> args;

    public MessageCommandEvent(CommandFramework framework, MessageReceivedEvent event, List<Argument> args) {
        this.event = event;
        this.args = Collections.unmodifiableList(new ArrayList<Argument>(args));
        this.framework = framework;
    }

    @Override
    public CommandFramework getFramework() {
        return this.framework;
    }

    @Override
    public List<Argument> getArgs() {
        return this.args;
    }

    @Override
    public Guild getGuild() {
        return this.event.getGuild();
    }

    @Override
    public JDA getJDA() {
        return this.event.getJDA();
    }

    @Override
    public User getAuthor() {
        return this.event.getAuthor();
    }

    @Override
    public Member getMember() {
        return this.event.getMember();
    }

    @Override
    public Message getMessage() {
        return this.event.getMessage();
    }

    @Override
    public MessageChannel getChannel() {
        return this.event.getChannel();
    }

    @Override
    public SelfUser getSelfUser() {
        return this.event.getJDA().getSelfUser();
    }

    @Override
    public Member getSelfMember() {
        return this.event.getGuild().getSelfMember();
    }

    @Override
    public RestAction<Message> reply(String message) {
        return this.event.getMessage().reply((CharSequence)message);
    }

    @Override
    public RestAction<Message> reply(MessageEmbed message) {
        return this.event.getMessage().replyEmbeds(message, new MessageEmbed[0]);
    }

    @Override
    public RestAction<Message> reply(MessageCreateData message) {
        return this.event.getMessage().reply(message);
    }

    @Override
    public String getId() {
        return this.event.getMessageId();
    }

    @Override
    public long getIdLong() {
        return this.event.getMessageIdLong();
    }

    @Override
    public PrivateChannel getPrivateChannel() {
        return this.event.getMessage().getChannel().asPrivateChannel();
    }

    @Override
    public RestAction<Void> deleteOriginalMessage() {
        return this.event.getMessage().delete();
    }

    public MessageReceivedEvent getEvent() {
        return this.event;
    }
}

