/*
 * Decompiled with CFR 0.152.
 */
package io.github.k7t3.javafx;

import io.github.k7t3.javafx.TableDataRowModel;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TableCell;

public abstract class DynamicTableCell<T>
extends TableCell<TableDataRowModel<T>, T> {
    protected final int columnIndex;
    protected final ReadOnlyDoubleProperty cellSizeProperty;
    private Node view;

    public DynamicTableCell(int index, ReadOnlyDoubleProperty cellSizeProperty) {
        this.columnIndex = index;
        this.cellSizeProperty = cellSizeProperty;
        this.prefWidthProperty().bind((ObservableValue)cellSizeProperty);
        this.prefHeightProperty().bind((ObservableValue)cellSizeProperty);
    }

    protected abstract Node createView();

    protected abstract void updateItem(T var1);

    protected void onEmpty() {
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (item == null || empty) {
            this.setGraphic(null);
            this.onEmpty();
            return;
        }
        if (this.view == null) {
            this.view = this.createView();
        }
        this.updateItem(item);
        this.setGraphic(this.view);
    }
}

