/*
 * Decompiled with CFR 0.152.
 */
package io.github.k7t3.javafx;

import io.github.k7t3.javafx.DynamicTableColumn;
import io.github.k7t3.javafx.DynamicTableView;
import io.github.k7t3.javafx.TableDataModel;
import io.github.k7t3.javafx.TableDataRowModel;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;

class DynamicTableViewSkin<T>
implements Skin<DynamicTableView<T>> {
    private static final System.Logger LOGGER = System.getLogger(DynamicTableViewSkin.class.getName());
    private final IntegerProperty columnCountProperty = new SimpleIntegerProperty();
    private final TableDataModel<T> dataModel = new TableDataModel();
    private final TableView<TableDataRowModel<T>> tableView;
    private final DynamicTableView<T> control;
    private boolean columnCountChanged = false;

    public DynamicTableViewSkin(DynamicTableView<T> control) {
        this.control = control;
        this.tableView = new TableView();
        this.init();
    }

    private void itemsChangeListener(ListChangeListener.Change<? extends T> c) {
        while (c.next()) {
            int i;
            if (c.wasUpdated()) {
                for (i = c.getFrom(); i < c.getTo(); ++i) {
                }
                continue;
            }
            if (c.wasPermutated()) {
                for (i = c.getFrom(); i < c.getTo(); ++i) {
                }
                continue;
            }
            if (c.wasAdded()) {
                if (this.columnCountChanged) continue;
                this.dataModel.normalizeRows();
                continue;
            }
            if (!c.wasRemoved()) continue;
            if (!this.columnCountChanged) {
                this.dataModel.normalizeRows();
            }
            this.control.selectedItems.removeAll((Collection)c.getRemoved());
        }
    }

    private void init() {
        LOGGER.log(System.Logger.Level.DEBUG, "init instance");
        this.tableView.placeholderProperty().bind(this.control.placeHolderProperty());
        this.tableView.getSelectionModel().setCellSelectionEnabled(true);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.control.itemsProperty().addListener((ob, o, n) -> {
            if (n == null) {
                this.control.filteredItemsProperty.set(null);
                this.control.sortedItemsProperty.set(null);
            } else {
                this.control.filteredItemsProperty.set((Object)new FilteredList(n));
                this.control.sortedItemsProperty.set((Object)new SortedList((ObservableList)this.control.filteredItemsProperty.get()));
            }
        });
        this.control.sortedItemsProperty().addListener((ob, o, n) -> {
            if (o != null) {
                o.removeListener(this::itemsChangeListener);
            }
            if (n != null) {
                n.addListener(this::itemsChangeListener);
                n.comparatorProperty().addListener((observable, oldValue, newValue) -> this.tableView.refresh());
            }
        });
        this.control.filteredItemsProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                newValue.predicateProperty().addListener((observable1, oldValue1, newValue1) -> this.tableView.refresh());
            }
        });
        this.control.getSortedItems().addListener(this::itemsChangeListener);
        this.control.getSortedItems().comparatorProperty().addListener((ob, o, n) -> this.tableView.refresh());
        this.dataModel.sortedProperty.bind(this.control.sortedItemsProperty());
        this.dataModel.columnCountProperty.bind((ObservableValue)this.columnCountProperty);
        this.tableView.setItems(this.dataModel.rows);
        this.control.widthProperty().addListener((p, o, n) -> {
            if (n != null && !o.equals(n)) {
                this.updateColumnCount(n.doubleValue());
            }
        });
        this.control.columnWidthProperty().addListener((ob, o, n) -> {
            if (n != null && !o.equals(n)) {
                this.updateColumnCount(this.control.getWidth());
                this.tableView.refresh();
            }
        });
        this.columnCountProperty.addListener((p, o, n) -> this.normalizeColumnCount());
        this.tableView.getSelectionModel().getSelectedCells().addListener(c -> {
            while (c.next()) {
                T picture;
                int column;
                int row;
                TablePosition position;
                int i;
                if (c.wasRemoved()) {
                    List changed = c.getRemoved();
                    for (i = changed.size() - 1; -1 < i; --i) {
                        position = (TablePosition)changed.get(i);
                        row = position.getRow();
                        picture = this.dataModel.get(row, column = position.getColumn());
                        if (picture == null) continue;
                        this.control.selectedItems.remove(picture);
                    }
                }
                if (!c.wasAdded()) continue;
                List list = c.getAddedSubList();
                for (i = list.size() - 1; -1 < i; --i) {
                    position = (TablePosition)list.get(i);
                    row = position.getRow();
                    picture = this.dataModel.get(row, column = position.getColumn());
                    if (picture == null) continue;
                    this.control.selectedItems.add(picture);
                }
            }
        });
        this.control.selectedItems.addListener(c -> {
            while (c.next()) {
                Object picture;
                Object list;
                if (c.wasRemoved()) {
                    list = c.getList();
                    if (list.isEmpty()) {
                        this.control.selectedItemProperty.set(null);
                    } else {
                        picture = list.get(list.size() - 1);
                        this.control.selectedItemProperty.set(picture);
                    }
                }
                if (!c.wasAdded()) continue;
                list = c.getAddedSubList();
                picture = list.get(list.size() - 1);
                this.control.selectedItemProperty.set(picture);
            }
        });
    }

    private void updateColumnCount(double viewWidth) {
        int columnCount = Math.max(1, (int)(viewWidth / this.control.getColumnWidth()));
        this.columnCountProperty.set(columnCount);
    }

    private void normalizeColumnCount() {
        int count;
        int currentCount = this.tableView.getColumns().size();
        if (currentCount == (count = this.columnCountProperty.get())) {
            return;
        }
        this.columnCountChanged = true;
        this.tableView.getSelectionModel().clearSelection();
        if (count < currentCount) {
            for (int i = 0; i < currentCount - count; ++i) {
                this.tableView.getColumns().remove(currentCount - i - 1);
            }
        } else {
            for (int i = currentCount; i < count; ++i) {
                DynamicTableColumn<T> column = new DynamicTableColumn<T>(this.control, i);
                column.columnSizeProperty.bind((ObservableValue)this.control.columnWidthProperty());
                this.tableView.getColumns().add(column);
            }
        }
        this.dataModel.normalizeRows();
        this.columnCountChanged = false;
    }

    public DynamicTableView<T> getSkinnable() {
        return this.control;
    }

    public Node getNode() {
        return this.tableView;
    }

    public void dispose() {
    }
}

