/*
 * Decompiled with CFR 0.152.
 */
package io.github.k7t3.javafx;

import io.github.k7t3.javafx.TableDataRowModel;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;

class TableDataModel<T> {
    ObjectProperty<SortedList<T>> sortedProperty = new SimpleObjectProperty();
    ObservableList<TableDataRowModel<T>> rows = FXCollections.observableArrayList();
    IntegerProperty columnCountProperty = new SimpleIntegerProperty();

    TableDataModel() {
    }

    SortedList<T> getSorted() {
        return (SortedList)this.sortedProperty.get();
    }

    private void normalizeRowCount(int rowCount) {
        int currentRowCount = this.rows.size();
        if (rowCount < currentRowCount) {
            for (int i = 0; i < currentRowCount - rowCount; ++i) {
                this.rows.remove(currentRowCount - i - 1);
            }
        } else if (currentRowCount < rowCount) {
            for (int i = currentRowCount; i < rowCount; ++i) {
                this.rows.add(new TableDataRowModel(i, this));
            }
        } else {
            this.rows.forEach(TableDataRowModel::update);
        }
    }

    void normalizeRows() {
        int columnCount = this.columnCountProperty.get();
        int rowCount = (int)Math.ceil((double)this.getSorted().size() / (double)columnCount);
        this.normalizeRowCount(rowCount);
    }

    T get(int rowIndex, int columnIndex) {
        int columnCount;
        int skip;
        int index;
        int count = this.getSorted().size();
        if (count - 1 < (index = (skip = rowIndex * (columnCount = this.columnCountProperty.get())) + columnIndex)) {
            return null;
        }
        return (T)this.getSorted().get(index);
    }
}

