/*
 * Decompiled with CFR 0.152.
 */
package io.github.k7t3.javafx;

import io.github.k7t3.javafx.TableDataModel;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

class TableDataRowModel<T> {
    private final int rowIndex;
    private final TableDataModel<T> model;
    private final Map<Integer, SimpleObjectProperty<T>> properties = new HashMap<Integer, SimpleObjectProperty<T>>(10);

    TableDataRowModel(int rowIndex, TableDataModel<T> model) {
        this.rowIndex = rowIndex;
        this.model = model;
    }

    public T get(int columnIndex) {
        return this.model.get(this.rowIndex, columnIndex);
    }

    ObservableValue<T> getProperty(int columnIndex) {
        SimpleObjectProperty property = this.properties.computeIfAbsent(columnIndex, i -> new SimpleObjectProperty());
        property.set(this.get(columnIndex));
        return property;
    }

    void update() {
        this.properties.forEach((key, value) -> value.set(this.get((int)key)));
    }
}

