/*
 * Decompiled with CFR 0.152.
 */
package io.github.k7t3.javafx;

import io.github.k7t3.javafx.DefaultDynamicTableCell;
import io.github.k7t3.javafx.DynamicTableCell;
import io.github.k7t3.javafx.DynamicTableCellValueFactory;
import io.github.k7t3.javafx.DynamicTableView;
import io.github.k7t3.javafx.TableDataRowModel;
import java.util.function.BiFunction;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;

class DynamicTableColumn<T>
extends TableColumn<TableDataRowModel<T>, T> {
    protected final DynamicTableView<T> control;
    int columnIndex;
    final DoubleProperty columnSizeProperty;

    DynamicTableColumn(DynamicTableView<T> control, int index) {
        this.control = control;
        this.columnIndex = index;
        this.columnSizeProperty = new SimpleDoubleProperty();
        if (control.getCellFactory() != null) {
            this.init(control.getCellFactory());
        } else {
            this.init(DefaultDynamicTableCell::new);
        }
    }

    private void init(BiFunction<Integer, ReadOnlyDoubleProperty, DynamicTableCell<T>> factory) {
        this.setCellValueFactory(new DynamicTableCellValueFactory());
        this.setCellFactory(column -> (TableCell)factory.apply(this.columnIndex, (ReadOnlyDoubleProperty)this.columnSizeProperty));
    }
}

