/*
 * Decompiled with CFR 0.152.
 */
package io.github.k7t3.javafx;

import io.github.k7t3.javafx.DynamicTableCell;
import io.github.k7t3.javafx.DynamicTableViewSkin;
import java.util.function.BiFunction;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;

public class DynamicTableView<T>
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "dynamic-table-view";
    public static double DEFAULT_COLUMN_WIDTH = 200.0;
    private final ObjectProperty<BiFunction<Integer, ReadOnlyDoubleProperty, DynamicTableCell<T>>> cellFactoryProperty = new SimpleObjectProperty(null);
    private final DoubleProperty columnWidthProperty = new SimpleDoubleProperty(DEFAULT_COLUMN_WIDTH);
    private final ObjectProperty<Node> placeHolderProperty = new SimpleObjectProperty((Object)new Label());
    private final ObjectProperty<ObservableList<T>> itemsProperty = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
    final ReadOnlyObjectWrapper<FilteredList<T>> filteredItemsProperty = new ReadOnlyObjectWrapper((Object)new FilteredList((ObservableList)this.itemsProperty.get()));
    final ReadOnlyObjectWrapper<SortedList<T>> sortedItemsProperty = new ReadOnlyObjectWrapper((Object)new SortedList((ObservableList)this.filteredItemsProperty.get()));
    final ReadOnlyObjectWrapper<T> selectedItemProperty = new ReadOnlyObjectWrapper();
    final ObservableList<T> selectedItems = FXCollections.observableArrayList();
    private final ObservableList<T> unmodifiableSelectedItems = FXCollections.unmodifiableObservableList(this.selectedItems);
    Runnable clearSelectionAction;
    private String styleSheet;

    public DynamicTableView() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setAccessibleRole(AccessibleRole.TABLE_VIEW);
    }

    public BiFunction<Integer, ReadOnlyDoubleProperty, DynamicTableCell<T>> getCellFactory() {
        return (BiFunction)this.cellFactoryProperty().get();
    }

    public ObjectProperty<BiFunction<Integer, ReadOnlyDoubleProperty, DynamicTableCell<T>>> cellFactoryProperty() {
        return this.cellFactoryProperty;
    }

    public void setCellFactory(BiFunction<Integer, ReadOnlyDoubleProperty, DynamicTableCell<T>> cellFactory) {
        this.cellFactoryProperty().set(cellFactory);
    }

    public double getColumnWidth() {
        return this.columnWidthProperty().get();
    }

    public DoubleProperty columnWidthProperty() {
        return this.columnWidthProperty;
    }

    public void setColumnWidth(double cellSize) {
        this.columnWidthProperty().set(cellSize);
    }

    public Node getPlaceHolder() {
        return (Node)this.placeHolderProperty().get();
    }

    public ObjectProperty<Node> placeHolderProperty() {
        return this.placeHolderProperty;
    }

    public void setPlaceHolder(Node placeHolder) {
        this.placeHolderProperty().set((Object)placeHolder);
    }

    public ObservableList<T> getItems() {
        return (ObservableList)this.itemsProperty().get();
    }

    public ObjectProperty<ObservableList<T>> itemsProperty() {
        return this.itemsProperty;
    }

    public void setItems(ObservableList<T> items) {
        this.itemsProperty().set(items);
    }

    public FilteredList<T> getFilteredItems() {
        return (FilteredList)this.filteredItemsProperty().get();
    }

    public ReadOnlyObjectProperty<FilteredList<T>> filteredItemsProperty() {
        return this.filteredItemsProperty.getReadOnlyProperty();
    }

    public SortedList<T> getSortedItems() {
        return (SortedList)this.sortedItemsProperty().get();
    }

    public ReadOnlyObjectProperty<SortedList<T>> sortedItemsProperty() {
        return this.sortedItemsProperty.getReadOnlyProperty();
    }

    public T getSelectedItem() {
        return (T)this.selectedItemProperty().get();
    }

    public ReadOnlyObjectProperty<T> selectedItemProperty() {
        return this.selectedItemProperty.getReadOnlyProperty();
    }

    public ObservableList<T> getUnmodifiableSelectedItems() {
        return this.unmodifiableSelectedItems;
    }

    public void clearSelection() {
        if (this.clearSelectionAction == null) {
            return;
        }
        this.clearSelectionAction.run();
    }

    protected Skin<?> createDefaultSkin() {
        return new DynamicTableViewSkin(this);
    }

    public String getUserAgentStylesheet() {
        if (this.styleSheet == null) {
            this.styleSheet = ((Object)((Object)this)).getClass().getResource("dynamictableview.css").toExternalForm();
        }
        return this.styleSheet;
    }
}

