package io.github.kaststream.api;

import java.io.Serializable;
import java.util.Map;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.co.CoProcessFunction;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.OutputTag;

/**
 * @deprecated This class will be remove in next version
 *     <p>Use {@link io.github.kaststream.api.v2.CoProcessor}
 */
public interface CoProcessor extends Serializable {

  /**
   * Gets the data type (as a {@link TypeInformation}) produced by this function or input format.
   *
   * @param typeInfo1 the input row type information from stream 1
   * @param typeInfo2 the input row type information from stream 2
   * @return The data type produced by this function or input format.
   */
  public TypeInformation<Row> getProducedType(
      final TypeInformation<Row> typeInfo1, final TypeInformation<Row> typeInfo2);

  /**
   * Declare the data type information of the sides out data produced by your function.
   *
   * @return the sides output type information
   */
  public default Map<String, TypeInformation<Row>> getSidesOutProducedType(
      final TypeInformation<Row> typeInfo1, final TypeInformation<Row> typeInfo2) {
    return null;
  }

  /**
   * This method is called for each element in the first of the connected streams.
   *
   * <p>This function can output zero or more elements using the {@link Collector} parameter and
   * also update internal state or set timers using the {@link CoProcessFunction.Context} parameter.
   *
   * @param value The stream element
   * @param ctx A {@link CoProcessFunction.Context} that allows querying the timestamp of the
   *     element, querying the {@link org.apache.flink.streaming.api.TimeDomain} of the firing timer
   *     and getting a {@link org.apache.flink.streaming.api.TimerService} for registering timers
   *     and querying the time. The context is only valid during the invocation of this method, do
   *     not store it.
   * @param out The collector to emit resulting elements to
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public void processElement1(
      final Row value, final CoProcessFunction<Row, Row, Row>.Context ctx, final Collector<Row> out)
      throws Exception;

  /**
   * This method is called for each element in the second of the connected streams.
   *
   * <p>This function can output zero or more elements using the {@link Collector} parameter and
   * also update internal state or set timers using the {@link CoProcessFunction.Context} parameter.
   *
   * @param value The stream element
   * @param ctx A {@link CoProcessFunction.Context} that allows querying the timestamp of the
   *     element, querying the {@link org.apache.flink.streaming.api.TimeDomain} of the firing timer
   *     and getting a {@link org.apache.flink.streaming.api.TimerService} for registering timers
   *     and querying the time. The context is only valid during the invocation of this method, do
   *     not store it.
   * @param out The collector to emit resulting elements to
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public void processElement2(
      final Row value, final CoProcessFunction<Row, Row, Row>.Context ctx, final Collector<Row> out)
      throws Exception;

  /**
   * Initialization method for the function.
   *
   * @param configuration The configuration containing the parameters attached to the contract
   * @param typeInfo1 the input row type information from stream 1
   * @param typeInfo2 the input row type information from stream 2
   * @param sidesOutputTag Side output typeinfo and tag dict if any
   * @param rtCtx a runtime context that allow you for example to manage state
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public void open(
      final Configuration configuration,
      final TypeInformation<Row> typeInfo1,
      final TypeInformation<Row> typeInfo2,
      final Map<String, OutputTag<Row>> sidesOutputTag,
      final RuntimeContext rtCtx)
      throws Exception;

  /**
   * Tear-down method for the user code. It is called after the last call to the main working
   * methods. For functions that are part of an iteration, this method will be invoked after each
   * iteration superstep.
   *
   * <p>This method can be used for clean up work.
   *
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public default void close() throws Exception {}
  ;
}
