/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.ChatImageCode;

import chatimage.okhttp3.Call;
import chatimage.okhttp3.Callback;
import chatimage.okhttp3.OkHttpClient;
import chatimage.okhttp3.Request;
import chatimage.okhttp3.Response;
import chatimage.okhttp3.ResponseBody;
import io.github.kituin.ChatImageCode.ChatImageHandler;
import java.io.IOException;
import java.util.HashMap;

public class ChatImageHttpHandler {
    public static HashMap<String, Integer> HTTPS_MAP = new HashMap();

    public static boolean getInputStream(final String url) {
        Request getRequest;
        OkHttpClient httpClient = new OkHttpClient();
        try {
            getRequest = new Request.Builder().url(url).get().build();
        }
        catch (IllegalArgumentException ep) {
            return false;
        }
        if (HTTPS_MAP.containsKey(url) && HTTPS_MAP.get(url) == 1) {
            return true;
        }
        HTTPS_MAP.put(url, 1);
        httpClient.newCall(getRequest).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                HTTPS_MAP.put(url, 2);
            }

            @Override
            public void onResponse(Call call, Response response) {
                String url2 = String.valueOf(call.request().url());
                ResponseBody body = response.body();
                if (body != null) {
                    try {
                        ChatImageHandler.loadFile(body.bytes(), url2);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                HTTPS_MAP.put(url2, 2);
            }
        });
        return true;
    }
}

