/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.ChatImageCode;

import io.github.kituin.ChatImageCode.ChatImageCodeInstance;
import io.github.kituin.ChatImageCode.ChatImageFrame;
import io.github.kituin.ChatImageCode.ClientStorage;
import io.github.kituin.ChatImageCode.FileImageHandler;
import io.github.kituin.ChatImageCode.HttpImageHandler;
import io.github.kituin.ChatImageCode.enums.UrlMethod;
import io.github.kituin.ChatImageCode.exception.InvalidChatImageCodeException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChatImageCode {
    public static final Pattern pattern = Pattern.compile("\\[\\[CICode,(.+)\\]\\]");
    private String url = null;
    private boolean nsfw = false;
    private String name = "codename.chatimage.default";
    private String prefix = "[";
    private String suffix = "]";
    private boolean isSelf = false;
    private final long timestamp;
    private String httpUrl;
    private UrlMethod urlMethod = UrlMethod.UNKNOWN;
    private String fileUrl;

    private ChatImageCode() {
        this.timestamp = System.currentTimeMillis();
    }

    public ChatImageFrame getFrame() {
        if (this.url == null) {
            return new ChatImageFrame(ChatImageFrame.FrameError.ILLEGAL_CICODE_ERROR);
        }
        ChatImageFrame frame = ClientStorage.getImage(this.getUrl());
        if (frame == null) {
            return new ChatImageFrame(ChatImageFrame.FrameError.LOADING);
        }
        return frame;
    }

    private void match(String originalCode) throws InvalidChatImageCodeException {
        Matcher matcher = pattern.matcher(originalCode);
        if (!matcher.find()) {
            throw new InvalidChatImageCodeException(originalCode + "<-can not find any String to ChatImageCode, Please Recheck");
        }
        this.slice(matcher.group(1));
    }

    private void slice(String rawCode) throws InvalidChatImageCodeException {
        String[] raws;
        for (String raw : raws = rawCode.split(",")) {
            String[] temps = raw.split("=", 2);
            if (temps.length == 2) {
                switch (temps[0].trim()) {
                    case "url": {
                        this.checkUrl(temps[1].trim());
                        break;
                    }
                    case "nsfw": {
                        this.nsfw = Boolean.parseBoolean(temps[1].trim());
                        break;
                    }
                    case "name": {
                        this.name = temps[1].trim();
                        break;
                    }
                    case "pre": {
                        this.prefix = temps[1];
                        break;
                    }
                    case "suf": {
                        this.suffix = temps[1];
                    }
                }
                continue;
            }
            throw new InvalidChatImageCodeException(raw + "<-can not match the value of ChatImageCode, Please Recheck");
        }
        if (this.url == null) {
            throw new InvalidChatImageCodeException("not match url in ChatImageCode, Please Recheck");
        }
    }

    public String getUrl() {
        switch (this.urlMethod) {
            case HTTP: {
                return this.httpUrl;
            }
            case FILE: {
                return this.fileUrl;
            }
        }
        return this.url;
    }

    public void checkUrl(String url) {
        URI uri;
        if (url == null) {
            ClientStorage.AddImageError(url, ChatImageFrame.FrameError.INVALID_URL);
            return;
        }
        this.url = url.replace("\\", "/");
        try {
            uri = new URI(this.url);
        }
        catch (URISyntaxException e) {
            ClientStorage.AddImageError(this.url, ChatImageFrame.FrameError.INVALID_URL);
            return;
        }
        ChatImageCodeInstance.ADAPTER.checkCachePath();
        if (Objects.equals(uri.getScheme(), "https") || Objects.equals(uri.getScheme(), "http")) {
            boolean f;
            this.urlMethod = UrlMethod.HTTP;
            this.httpUrl = uri.toString();
            if (!ClientStorage.ContainImage(this.httpUrl) && !(f = HttpImageHandler.request(this.httpUrl))) {
                ClientStorage.AddImageError(this.httpUrl, ChatImageFrame.FrameError.INVALID_HTTP_URL);
            }
        } else if (Objects.equals(uri.getScheme(), "file")) {
            this.urlMethod = UrlMethod.FILE;
            this.fileUrl = uri.toString().replace("file:///", "");
            File file = new File(this.fileUrl);
            if (!ClientStorage.ContainImage(this.fileUrl)) {
                boolean fileExist = file.exists();
                if (fileExist) {
                    FileImageHandler.loadFile(this.fileUrl);
                }
                ChatImageCodeInstance.ADAPTER.sendPacket(this.fileUrl, file, fileExist);
            }
        } else {
            ClientStorage.AddImageError(this.url, ChatImageFrame.FrameError.INVALID_URL);
        }
    }

    public void retry() {
        this.checkUrl(this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[[CICode");
        if (this.nsfw) {
            sb.append(",nsfw=true");
        }
        if (this.name != null) {
            sb.append(",name=").append(this.name);
        }
        sb.append(",url=").append(this.url);
        return sb.append("]]").toString();
    }

    public String getName() {
        return this.name;
    }

    public boolean isNsfw() {
        return this.nsfw;
    }

    public boolean isSendFromSelf() {
        return this.isSelf;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() > this.timestamp + 1000L * (long)ChatImageCodeInstance.ADAPTER.getTimeOut();
    }

    public static class Builder {
        private final ChatImageCode code = new ChatImageCode();

        public ChatImageCode build() {
            return this.code;
        }

        public Builder fromCode(String ciCode) throws InvalidChatImageCodeException {
            this.code.match(ciCode);
            return this;
        }

        public Builder setName(String name) {
            this.code.name = name;
            return this;
        }

        public Builder setUrl(String url) {
            this.code.checkUrl(url);
            return this;
        }

        public Builder setNsfw(boolean nsfw) {
            this.code.nsfw = nsfw;
            return this;
        }

        public Builder setIsSelf(boolean isSelf) {
            this.code.isSelf = isSelf;
            return this;
        }

        public Builder setPrefix(String prefix) {
            this.code.prefix = prefix;
            return this;
        }

        public Builder setSuffix(String suffix) {
            this.code.suffix = suffix;
            return this;
        }
    }
}

