/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.ChatImageCode;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.IOUtils;

public class ChatImageConfig {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setLenient().setPrettyPrinting().create();
    public String cachePath = "ChatImageCache";
    public int limitWidth = 125;
    public int limitHeight = 125;
    public int paddingLeft = 1;
    public int paddingRight = 1;
    public int paddingTop = 1;
    public int paddingBottom = 1;
    public int gifSpeed = 3;
    public boolean nsfw = false;
    public boolean cqCode = true;
    public boolean checkImageUri = true;
    public boolean dragUseCicode = true;
    public int timeout = 5;
    public static File configFile;

    public void save() {
        ChatImageConfig.saveConfig(this);
    }

    public static ChatImageConfig loadConfig() {
        try {
            ChatImageConfig config;
            if (configFile.exists()) {
                String json = IOUtils.toString((Reader)new InputStreamReader(Files.newInputStream(configFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
                config = (ChatImageConfig)GSON.fromJson(json, ChatImageConfig.class);
            } else {
                config = new ChatImageConfig();
            }
            ChatImageConfig.saveConfig(config);
            return config;
        }
        catch (IOException e) {
            return new ChatImageConfig();
        }
    }

    public static void saveConfig(ChatImageConfig config) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(configFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
            writer.write(GSON.toJson((Object)config));
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

