/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.ChatImageCode;

import chatimage.com.madgag.gif.fmsware.GifDecoder;
import chatimage.net.sf.image4j.codec.ico.ICODecoder;
import io.github.kituin.ChatImageCode.ChatImageFrame;
import io.github.kituin.ChatImageCode.ClientStorage;
import io.github.kituin.ChatImageCode.enums.ChatImageType;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;

public class FileImageHandler {
    public static String bytesToHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (byte aByte : bytes) {
            String hex = Integer.toHexString(aByte & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static ChatImageType getPicType(byte[] is) {
        byte[] b = new byte[4];
        System.arraycopy(is, 0, b, 0, b.length);
        String type_ = FileImageHandler.bytesToHex(b).toUpperCase();
        if (type_.startsWith("47494638")) {
            return ChatImageType.GIF;
        }
        if (type_.startsWith("00000100")) {
            return ChatImageType.ICO;
        }
        if (type_.startsWith("52494646")) {
            return ChatImageType.WEBP;
        }
        return ChatImageType.PNG;
    }

    public static void loadGif(InputStream is, String url) {
        CompletableFuture.supplyAsync(() -> {
            GifDecoder gd = new GifDecoder();
            int status = gd.read(is);
            if (status != 0) {
                ClientStorage.AddImageError(url, ChatImageFrame.FrameError.FILE_LOAD_ERROR);
                return null;
            }
            ChatImageFrame frame = new ChatImageFrame(gd.getFrame(0));
            for (int i = 1; i < gd.getFrameCount(); ++i) {
                frame.append(new ChatImageFrame(gd.getFrame(i)));
            }
            if (frame.checkLoad()) {
                ClientStorage.AddImage(url, frame);
            } else {
                ClientStorage.AddImageError(url, ChatImageFrame.FrameError.FILE_LOAD_ERROR);
            }
            return null;
        });
    }

    public static void loadGif(byte[] is, String url) {
        FileImageHandler.loadGif(new ByteArrayInputStream(is), url);
    }

    public static void loadFile(InputStream input, String url) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        try {
            int nRead;
            while ((nRead = input.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
        }
        catch (IOException ex) {
            ClientStorage.AddImageError(url, ChatImageFrame.FrameError.FILE_LOAD_ERROR);
            return;
        }
        byte[] byteArray = buffer.toByteArray();
        FileImageHandler.loadFile(byteArray, url);
    }

    public static void loadFile(String url) {
        try {
            FileImageHandler.loadFile(Files.newInputStream(Paths.get(url, new String[0]), new OpenOption[0]), url);
        }
        catch (IOException ex) {
            ClientStorage.AddImageError(url, ChatImageFrame.FrameError.FILE_LOAD_ERROR);
        }
    }

    public static void loadFile(byte[] input, String url) {
        ChatImageType t = FileImageHandler.getPicType(input);
        if (t == ChatImageType.GIF) {
            FileImageHandler.loadGif(input, url);
        } else if (t == ChatImageType.ICO) {
            try {
                List<BufferedImage> images = ICODecoder.read(new ByteArrayInputStream(input));
                ClientStorage.AddImage(url, new ChatImageFrame(images.get(0)));
            }
            catch (IOException ex) {
                ClientStorage.AddImageError(url, ChatImageFrame.FrameError.FILE_LOAD_ERROR);
            }
        } else if (t == ChatImageType.PNG) {
            try {
                ClientStorage.AddImage(url, new ChatImageFrame(ImageIO.read(new ByteArrayInputStream(input))));
            }
            catch (IOException ex) {
                ClientStorage.AddImageError(url, ChatImageFrame.FrameError.FILE_LOAD_ERROR);
            }
        } else {
            ClientStorage.AddImageError(url, ChatImageFrame.FrameError.IMAGE_TYPE_NOT_SUPPORT);
        }
    }
}

