package com.liecoder.framework.dialog

import android.animation.ValueAnimator.INFINITE
import android.app.Dialog
import android.content.Context
import android.view.LayoutInflater
import android.view.View.GONE
import android.view.View.VISIBLE
import android.view.Window
import android.view.animation.Animation
import android.view.animation.LinearInterpolator
import android.view.animation.RotateAnimation
import com.liecoder.framework.R
import com.liecoder.framework.databinding.LayoutLoadingDialogBinding
import com.liecoder.framework.ktx.radius

/**
 * Author: liecoder
 * Date: 2024/6/21 周五
 * Version: 1.0
 */
class LoadingDialog(context: Context) : Dialog(
    context, R.style.loading_dialog
) {

    private val mBinding: LayoutLoadingDialogBinding
    private var animation: Animation? = null

    init {
        requestWindowFeature(Window.FEATURE_NO_TITLE)
        setCanceledOnTouchOutside(false)
        setCancelable(false)
        mBinding = LayoutLoadingDialogBinding.inflate(LayoutInflater.from(context))
        setContentView(mBinding.root.radius(8))
        setAnimation()
    }

    private fun setAnimation() {
        animation = RotateAnimation(
            0f, 360f, Animation.RELATIVE_TO_SELF, 0.5f, Animation.RELATIVE_TO_SELF, 0.5f
        ).apply {
            duration = 1_440
            interpolator = LinearInterpolator()
            repeatCount = INFINITE
            fillAfter = false
        }
    }

    fun setLoadingMessage(message: String?) {
        if (message.isNullOrEmpty()) {
            mBinding.tvLoadingMessage.visibility = GONE
        } else {
            mBinding.tvLoadingMessage.text = message
            mBinding.tvLoadingMessage.visibility = VISIBLE
        }
    }

    override fun show() {
        super.show()
        mBinding.ivLoading.startAnimation(animation)
    }

    override fun dismiss() {
        super.dismiss()
        mBinding.ivLoading.clearAnimation()
    }

}