package com.liecoder.framework.service

import com.liecoder.framework.model.BuildType

/**
 * 构建类型服务接口，用于提供当前应用程序的构建类型信息。
 *
 * 此接口定义了一个方法，用于获取应用程序的当前构建类型。实现此接口的类应该能够确定并提供应用程序的构建环境，
 * 例如开发环境、测试环境或生产环境。
 */
interface IBuildTypeService {

    /**
     * 获取当前应用程序的构建类型。
     *
     * 此属性返回一个[BuildType]枚举值，表示应用程序的当前构建环境。根据这个值，应用程序可以应用不同的配置和行为。
     *
     * @return 当前应用程序的构建类型枚举值。
     */
    val buildType: BuildType

}