/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca.enums;

public enum OrderEvent {
    NEW("new"),
    FILL("fill"),
    PARTIALLY_FILLED("partially_filled"),
    FILLED("filled"),
    DONE_FOR_DAY("done_for_day"),
    CANCELED("canceled"),
    EXPIRED("expired"),
    PENDING_CANCEL("pending_cancel"),
    STOPPED("stopped"),
    REJECTED("rejected"),
    SUSPENDED("suspended"),
    PENDING_NEW("pending_new"),
    CALCULATED("calculated");

    private String apiName;

    private OrderEvent(String apiName) {
        this.apiName = apiName;
    }

    public String getAPIName() {
        return this.apiName;
    }

    public static OrderEvent fromAPIName(String apiName) {
        for (OrderEvent event : OrderEvent.values()) {
            if (!event.getAPIName().equals(apiName.trim())) continue;
            return event;
        }
        return null;
    }
}

