/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.polygon.nats;

import io.github.mainstringargs.polygon.enums.ChannelType;
import io.github.mainstringargs.polygon.nats.PolygonStreamListener;
import io.github.mainstringargs.polygon.nats.message.ChannelMessage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PolygonStreamListenerAdapter
implements PolygonStreamListener {
    private Map<String, Set<ChannelType>> stockChannelTypes = new HashMap<String, Set<ChannelType>>();

    public PolygonStreamListenerAdapter(String ticker, ChannelType ... channelTypes) {
        if (channelTypes != null && channelTypes.length > 0) {
            this.stockChannelTypes.put(ticker, new HashSet<ChannelType>(Arrays.asList(channelTypes)));
        } else {
            this.stockChannelTypes.put(ticker, new HashSet<ChannelType>(Arrays.asList(ChannelType.values())));
        }
    }

    public PolygonStreamListenerAdapter(Set<String> tickers, ChannelType ... channelTypes) {
        for (String ticker : tickers) {
            if (channelTypes != null && channelTypes.length > 0) {
                this.stockChannelTypes.put(ticker, new HashSet<ChannelType>(Arrays.asList(channelTypes)));
                continue;
            }
            this.stockChannelTypes.put(ticker, new HashSet<ChannelType>(Arrays.asList(ChannelType.values())));
        }
    }

    public PolygonStreamListenerAdapter(Map<String, Set<ChannelType>> stockChannelTypes) {
        for (Map.Entry<String, Set<ChannelType>> entry : stockChannelTypes.entrySet()) {
            stockChannelTypes.put(entry.getKey(), new HashSet(entry.getValue()));
        }
    }

    @Override
    public Map<String, Set<ChannelType>> getStockChannelTypes() {
        return this.stockChannelTypes;
    }

    @Override
    public void streamUpdate(String ticker, ChannelType channelType, ChannelMessage message) {
    }
}

