/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.polygon.properties;

import io.github.mainstringargs.alpaca.properties.AlpacaProperties;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PolygonProperties {
    private static LinkedHashSet<Properties> propertyFiles = new LinkedHashSet();
    private static Logger LOGGER = LogManager.getLogger(PolygonProperties.class);
    private static final String KEY_ID_KEY = "key_id";
    private static final String BASE_DATA_URL_KEY = "base_data_url";
    private static final String USER_AGENT_KEY = "user_agent";
    private static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36";
    private static final String DEFAULT_DATA_URL = "https://api.polygon.io";
    public static final String INVALID_VALUE = "<PLACEHOLDER>";
    public static final String KEY_ID_VALUE;
    public static String BASE_DATA_URL_VALUE;
    private static String POLYGON_NATS_SERVERS_KEY;
    private static String DEFAULT_POLYGON_NATS_SERVERS;
    public static String[] POLYGON_NATS_SERVERS_VALUE;
    public static final String USER_AGENT_VALUE;

    public static String getProperty(String key, String defaultValue) {
        for (Properties prop : propertyFiles) {
            String propertyVal;
            if (!prop.containsKey(key) || (propertyVal = prop.getProperty(key)).equals(INVALID_VALUE) || propertyVal.trim().isEmpty()) continue;
            LOGGER.debug("Loading " + key + " " + propertyVal);
            return propertyVal.trim();
        }
        LOGGER.debug("Loading " + key + " " + defaultValue);
        return defaultValue.trim();
    }

    static {
        Enumeration<URL> urls = null;
        try {
            urls = ClassLoader.getSystemClassLoader().getResources("polygon.properties");
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        while (urls.hasMoreElements()) {
            InputStream is = null;
            try {
                URL url = urls.nextElement();
                LOGGER.info("Found polygon.properties File: " + url);
                is = url.openStream();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            Properties propertyFile = new Properties();
            try {
                propertyFile.load(is);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            propertyFiles.add(propertyFile);
        }
        KEY_ID_VALUE = PolygonProperties.getProperty(KEY_ID_KEY, AlpacaProperties.KEY_ID_VALUE);
        BASE_DATA_URL_VALUE = PolygonProperties.getProperty(BASE_DATA_URL_KEY, DEFAULT_DATA_URL);
        POLYGON_NATS_SERVERS_KEY = "nats_urls";
        DEFAULT_POLYGON_NATS_SERVERS = "nats1.polygon.io:31101,nats2.polygon.io:31102,nats3.polygon.io:31103";
        POLYGON_NATS_SERVERS_VALUE = PolygonProperties.getProperty(POLYGON_NATS_SERVERS_KEY, DEFAULT_POLYGON_NATS_SERVERS).split(",");
        USER_AGENT_VALUE = PolygonProperties.getProperty(USER_AGENT_KEY, DEFAULT_USER_AGENT);
    }
}

