/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca.websocket;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.mainstringargs.util.concurrency.ExecutorTracer;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ClientEndpoint
public class AlpacaWebsocketClientEndpoint {
    Session userSession = null;
    private MessageHandler messageHandler;
    private URI endpointURI;
    private static Logger LOGGER = LogManager.getLogger(AlpacaWebsocketClientEndpoint.class);
    private static final ExecutorService executor = ExecutorTracer.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "AlpacaWebsocketThread");
        }
    });

    public AlpacaWebsocketClientEndpoint(URI endpointURI) {
        this.endpointURI = endpointURI;
        try {
            this.connect(endpointURI);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void connect(URI endpointURI) throws DeploymentException, IOException {
        WebSocketContainer container = ContainerProvider.getWebSocketContainer();
        LOGGER.info("Connecting to " + endpointURI);
        container.connectToServer((Object)this, endpointURI);
    }

    @OnOpen
    public void onOpen(Session userSession) {
        this.userSession = userSession;
        LOGGER.info("onOpen " + userSession);
    }

    @OnClose
    public void onClose(Session userSession, CloseReason reason) {
        this.userSession = null;
        LOGGER.info("onClose " + userSession + " " + reason);
        try {
            this.connect(this.endpointURI);
        }
        catch (Exception e) {
            LOGGER.catching((Throwable)e);
        }
    }

    @OnMessage
    public void onMessage(final byte[] message) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("onMessage " + new String(message));
                }
                if (AlpacaWebsocketClientEndpoint.this.messageHandler != null) {
                    JsonElement jelement = new JsonParser().parse(new String(message));
                    JsonObject jobject = jelement.getAsJsonObject();
                    AlpacaWebsocketClientEndpoint.this.messageHandler.handleMessage(jobject);
                }
            }
        });
    }

    public void addMessageHandler(MessageHandler msgHandler) {
        this.messageHandler = msgHandler;
    }

    public void sendMessage(String message) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("sendMessage " + message);
        }
        this.userSession.getAsyncRemote().sendText(message);
    }

    public Session getUserSession() {
        return this.userSession;
    }

    public static interface MessageHandler {
        public void handleMessage(JsonObject var1);
    }
}

