/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.polygon.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.GetRequest;
import io.github.mainstringargs.alpaca.properties.AlpacaProperties;
import io.github.mainstringargs.polygon.domain.aggregate.Aggregates;
import io.github.mainstringargs.polygon.rest.PolygonRequestBuilder;
import java.lang.reflect.Type;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PolygonRequest {
    private static final String LAST_JSON_KEY = "last";
    private static final String COUNT_JSON_KEY = "count";
    private static final String TICKERS_JSON_KEY = "tickers";
    private static final String TICKER_JSON_KEY = "ticker";
    private static final String STATUS_JSON_KEY = "status";
    private static final String RESULTS_JSON_KEY = "results";
    private static Logger LOGGER = LogManager.getLogger(PolygonRequest.class);
    private static final String USER_AGENT_KEY = "user-agent";
    private static final String API_KEY_ID = "apiKey";
    private String keyId;

    public PolygonRequest(String keyId) {
        this.keyId = keyId;
    }

    public HttpResponse<JsonNode> invokeGet(PolygonRequestBuilder builder) {
        HttpResponse response = null;
        try {
            builder.appendURLParameter(API_KEY_ID, this.keyId);
            LOGGER.debug("Get URL " + builder.getURL());
            GetRequest getResponse = Unirest.get((String)builder.getURL()).header(USER_AGENT_KEY, AlpacaProperties.USER_AGENT_VALUE);
            response = getResponse.asJson();
            LOGGER.debug("GET status: " + response.getStatus() + "\n\t\t\t\t\tstatusText: " + response.getStatusText() + "\n\t\t\t\t\tBody: " + response.getBody());
        }
        catch (UnirestException e) {
            LOGGER.info("UnirestException", (Throwable)e);
        }
        return response;
    }

    public HttpResponse<JsonNode> invokePost(PolygonRequestBuilder builder) {
        HttpResponse response = null;
        try {
            builder.appendURLParameter(API_KEY_ID, this.keyId);
            LOGGER.debug("Post URL " + builder.getURL());
            LOGGER.debug("Post Body " + builder.getBodyAsJSON());
            response = Unirest.post((String)builder.getURL()).header(USER_AGENT_KEY, AlpacaProperties.USER_AGENT_VALUE).body(builder.getBodyAsJSON()).asJson();
            LOGGER.debug("POST status: " + response.getStatus() + "\n\t\t\t\t\tstatusText: " + response.getStatusText() + "\n\t\t\t\t\tBody: " + response.getBody());
        }
        catch (UnirestException e) {
            LOGGER.info("UnirestException", (Throwable)e);
        }
        return response;
    }

    public HttpResponse<JsonNode> invokeDelete(PolygonRequestBuilder builder) {
        HttpResponse response = null;
        try {
            builder.appendURLParameter(API_KEY_ID, this.keyId);
            LOGGER.debug("Delete URL " + builder.getURL());
            response = Unirest.delete((String)builder.getURL()).header(USER_AGENT_KEY, AlpacaProperties.USER_AGENT_VALUE).asJson();
            LOGGER.debug("DELETE status: " + response.getStatus() + "\n\t\t\t\t\tstatusText: " + response.getStatusText() + "\n\t\t\t\t\tBody: " + response.getBody());
        }
        catch (UnirestException e) {
            LOGGER.info("UnirestException", (Throwable)e);
        }
        return response;
    }

    public <T> T getResponseObject(HttpResponse<JsonNode> httpResponse, Type type) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setLenient();
        Gson gson = gsonBuilder.create();
        Object responseObjectFromJson = null;
        try {
            JsonNode node = (JsonNode)httpResponse.getBody();
            String rawNodeString = null;
            rawNodeString = type == Aggregates.class ? ((JsonNode)httpResponse.getBody()).toString() : (!node.isArray() && node.getObject().has(RESULTS_JSON_KEY) ? node.getObject().get(RESULTS_JSON_KEY).toString() : (!node.isArray() && node.getObject().has(TICKER_JSON_KEY) && node.getObject().has(STATUS_JSON_KEY) && node.getObject().length() == 2 ? node.getObject().get(TICKER_JSON_KEY).toString() : (!node.isArray() && node.getObject().has(TICKERS_JSON_KEY) && node.getObject().has(STATUS_JSON_KEY) && node.getObject().length() == 2 ? node.getObject().get(TICKERS_JSON_KEY).toString() : (!node.isArray() && node.getObject().has(TICKERS_JSON_KEY) && node.getObject().has(STATUS_JSON_KEY) && node.getObject().has(COUNT_JSON_KEY) && node.getObject().length() == 3 ? node.getObject().get(TICKERS_JSON_KEY).toString() : (!node.isArray() && node.getObject().has(LAST_JSON_KEY) ? node.getObject().get(LAST_JSON_KEY).toString() : ((JsonNode)httpResponse.getBody()).toString())))));
            responseObjectFromJson = gson.fromJson(rawNodeString, type);
        }
        catch (Exception e) {
            LOGGER.info("Exception", (Throwable)e);
        }
        return (T)responseObjectFromJson;
    }
}

