/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbridge.props;

import io.github.kbridge.props.TransformerContainer;
import io.github.kbridge.transform.KafkaPayloadTransformer;
import io.github.kbridge.transform.MqPayloadTransformer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EtlProperties {
    private static final Logger log = LoggerFactory.getLogger(EtlProperties.class);
    private Map<String, Set<String>> targetDestination;
    private Map<String, List<MqPayloadTransformer>> mqMap;
    private Map<String, List<KafkaPayloadTransformer>> kafkaMap;
    @Autowired(required=false)
    private List<MqPayloadTransformer> mqPayloadTransformers;
    @Autowired(required=false)
    private List<KafkaPayloadTransformer> kafkaMqPayloadTransformers;
    @Autowired
    private TransformerContainer transformerContainer;

    @PostConstruct
    public void init() {
        this.mqMap = new ConcurrentHashMap<String, List<MqPayloadTransformer>>();
        this.kafkaMap = new ConcurrentHashMap<String, List<KafkaPayloadTransformer>>();
        this.targetDestination = new ConcurrentHashMap<String, Set<String>>();
        if (Objects.nonNull(this.mqPayloadTransformers)) {
            this.mqPayloadTransformers.stream().forEach(s -> {
                Set<String> list = this.targetDestination.get(s.mqTopic());
                if (Objects.isNull(list)) {
                    list = new HashSet<String>();
                    this.targetDestination.put(s.mqTopic(), list);
                }
                list.add(s.kafkaTopic());
                this.addMqTransformer((MqPayloadTransformer)s);
            });
        }
        if (Objects.nonNull(this.kafkaMqPayloadTransformers)) {
            this.kafkaMqPayloadTransformers.stream().forEach(s -> {
                Set<String> list = this.targetDestination.get(s.kafkaTopic());
                if (Objects.isNull(list)) {
                    list = new HashSet<String>();
                    this.targetDestination.put(s.kafkaTopic(), list);
                }
                list.add(s.kafkaTopic());
                this.addKafkaTransformer((KafkaPayloadTransformer)s);
            });
        }
        String kafkaTopicList = this.kafkaMap.keySet().stream().collect(Collectors.joining(","));
        System.setProperty("app.kafka.topics", "default-Topic");
        if (StringUtils.isNotBlank((CharSequence)kafkaTopicList)) {
            System.setProperty("app.kafka.enabled", "true");
            System.setProperty("app.kafka.topics", kafkaTopicList);
        }
        log.info("topic target mapping: {} ", this.targetDestination);
    }

    private void addKafkaTransformer(KafkaPayloadTransformer s) {
        List<KafkaPayloadTransformer> list = this.kafkaMap.get(s.kafkaTopic());
        if (Objects.isNull(list)) {
            list = new ArrayList<KafkaPayloadTransformer>();
            this.kafkaMap.put(s.kafkaTopic(), list);
        }
        list.add(s);
        this.transformerContainer.registerTransformer(s);
    }

    private void addMqTransformer(MqPayloadTransformer s) {
        List<MqPayloadTransformer> list = this.mqMap.get(s.mqTopic());
        if (Objects.isNull(list)) {
            list = new ArrayList<MqPayloadTransformer>();
            this.mqMap.put(s.mqTopic(), list);
        }
        list.add(s);
        this.transformerContainer.registerTransformer(s);
    }

    public Map<String, Set<String>> getTargetDestination() {
        return this.targetDestination;
    }

    public Map<String, List<MqPayloadTransformer>> getMqMap() {
        return this.mqMap;
    }

    public Map<String, List<KafkaPayloadTransformer>> getKafkaMap() {
        return this.kafkaMap;
    }

    public List<MqPayloadTransformer> getMqPayloadTransformers() {
        return this.mqPayloadTransformers;
    }

    public List<KafkaPayloadTransformer> getKafkaMqPayloadTransformers() {
        return this.kafkaMqPayloadTransformers;
    }

    public TransformerContainer getTransformerContainer() {
        return this.transformerContainer;
    }
}

