/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbridge.props;

import io.github.kbridge.transform.KafkaPayloadTransformer;
import io.github.kbridge.transform.MqPayloadTransformer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.springframework.messaging.MessageHeaders;
import org.springframework.stereotype.Component;

@Component
public class TransformerContainer {
    private Map<String, MqPayloadTransformer> mqTransformerMap;
    private Map<String, KafkaPayloadTransformer> kafkaTransformerMap;

    @PostConstruct
    public void init() {
        this.mqTransformerMap = new ConcurrentHashMap<String, MqPayloadTransformer>();
        this.kafkaTransformerMap = new ConcurrentHashMap<String, KafkaPayloadTransformer>();
    }

    public void registerTransformer(MqPayloadTransformer s) {
        String key = this.buildKey(s.mqTopic(), s.kafkaTopic());
        this.mqTransformerMap.put(key, s);
    }

    private String buildKey(String from, String to) {
        return String.format("%s->%s", from, to);
    }

    public void registerTransformer(KafkaPayloadTransformer s) {
        String key = this.buildKey(s.kafkaTopic(), s.mqTopic());
        this.kafkaTransformerMap.put(key, s);
    }

    public MqPayloadTransformer findMqTransformer(String mqtopic, String kafkaTopic) {
        String key = this.buildKey(mqtopic, kafkaTopic);
        return this.mqTransformerMap.get(key);
    }

    public MqPayloadTransformer findMqTransformer(MessageHeaders headers) {
        String mqTopic = (String)headers.get((Object)"mqTopic");
        String kafkaTopic = (String)headers.get((Object)"kafkatopic");
        return this.findMqTransformer(mqTopic, kafkaTopic);
    }

    public KafkaPayloadTransformer findKafkaTransformer(String kafkaTopic, String mqtopic) {
        String key = this.buildKey(kafkaTopic, mqtopic);
        return this.kafkaTransformerMap.get(key);
    }

    public KafkaPayloadTransformer findKafkaTransformer(MessageHeaders headers) {
        String mqTopic = (String)headers.get((Object)"mqTopic");
        String kafkaTopic = (String)headers.get((Object)"kafkatopic");
        return this.findKafkaTransformer(kafkaTopic, mqTopic);
    }
}

