/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbridge.listener;

import io.github.kbridge.props.ChannelNames;
import io.github.kbridge.transform.MqPayloadTransformer;
import io.github.kbridge.util.TransformerUtil;
import java.util.HashMap;
import java.util.List;
import javax.jms.MessageListener;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.stereotype.Component;

@Component
public class CommonJmsListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(CommonJmsListener.class);
    @Autowired
    private MessagingTemplate messagingTemplate;
    @Autowired
    private TransformerUtil transformerUtil;

    public void onMessage(javax.jms.Message message) {
        log.debug("MessageListener-received from mq ");
        String mqTopic = this.transformerUtil.extractTopic(message);
        List<MqPayloadTransformer> transformers = this.transformerUtil.findMqTransformer(message);
        for (MqPayloadTransformer transformer : transformers) {
            Object kafkaPayload = transformer.transformToKafka(message);
            ProducerRecord producerRecord = new ProducerRecord(transformer.kafkaTopic(), kafkaPayload);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("mqTopic", mqTopic);
            headers.put("kafkatopic", transformer.kafkaTopic());
            GenericMessage genericMessage = new GenericMessage((Object)producerRecord, headers);
            this.messagingTemplate.send(ChannelNames.TO_KAFKA.bean(), (Message)genericMessage);
            log.debug("sent to : {} ", (Object)ChannelNames.TO_KAFKA.bean());
        }
    }
}

